/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.commitment;

import org.cryptimeleon.craco.commitment.CommitmentPair;
import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.junit.Assert;

public class CommitmentSchemeTester {
    public static void testCommitmentSchemeVerify(CommitmentScheme commitmentScheme, PlainText message) {
        CommitmentPair commitmentPair = commitmentScheme.commit(message);
        Assert.assertTrue((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair.getOpenValue(), message));
    }

    public static void testCommitmentSchemeVerifyWithWrongMessages(CommitmentScheme commitmentScheme, PlainText originalMessage, PlainText wrongMessage) {
        CommitmentPair commitmentPair = commitmentScheme.commit(originalMessage);
        CommitmentPair commitmentPair2 = commitmentScheme.commit(wrongMessage);
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair.getOpenValue(), wrongMessage));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair2.getOpenValue(), wrongMessage));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair2.getOpenValue(), originalMessage));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair2.getCommitment(), commitmentPair.getOpenValue(), wrongMessage));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair2.getCommitment(), commitmentPair2.getOpenValue(), originalMessage));
    }

    public static void testCommitmentSchemeMapToPlaintext(CommitmentScheme commitmentScheme, PlainText message) {
        CommitmentPair commitmentPair = commitmentScheme.commit(commitmentScheme.mapToPlainText(message.getUniqueByteRepresentation()));
        Assert.assertTrue((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair.getOpenValue(), commitmentScheme.mapToPlainText(message.getUniqueByteRepresentation())));
    }

    public static void testCommitmentSchemeMapToPlainTextWithWrongMessages(CommitmentScheme commitmentScheme, PlainText originalMessage, PlainText wrongMessage) {
        CommitmentPair commitmentPair = commitmentScheme.commit(commitmentScheme.mapToPlainText(originalMessage.getUniqueByteRepresentation()));
        CommitmentPair commitmentPair2 = commitmentScheme.commit(commitmentScheme.mapToPlainText(wrongMessage.getUniqueByteRepresentation()));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair.getOpenValue(), commitmentScheme.mapToPlainText(wrongMessage.getUniqueByteRepresentation())));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair2.getOpenValue(), commitmentScheme.mapToPlainText(wrongMessage.getUniqueByteRepresentation())));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair2.getOpenValue(), commitmentScheme.mapToPlainText(originalMessage.getUniqueByteRepresentation())));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair2.getCommitment(), commitmentPair.getOpenValue(), commitmentScheme.mapToPlainText(wrongMessage.getUniqueByteRepresentation())));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair2.getCommitment(), commitmentPair2.getOpenValue(), commitmentScheme.mapToPlainText(originalMessage.getUniqueByteRepresentation())));
    }
}

