/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKeyPair;
import org.cryptimeleon.craco.enc.EncryptionScheme;
import org.cryptimeleon.craco.enc.TestParams;
import org.cryptimeleon.craco.enc.params.ElgamalParams;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EncryptionSchemeTest {
    private Supplier<PlainText> plaintextSupplier;
    private EncryptionScheme encryptionScheme;
    private EncryptionKeyPair validKeyPair;
    private EncryptionKeyPair invalidKeyPair;

    public EncryptionSchemeTest(TestParams params) {
        this.encryptionScheme = params.encryptionScheme;
        this.plaintextSupplier = params.plainTextSupplier;
        this.validKeyPair = params.validKeyPair;
        this.invalidKeyPair = params.invalidKeyPair;
    }

    @Test
    public void testEncryptDecrypt() throws UnsupportedEncodingException {
        System.out.println("Testing valid encrypt/decrypt for " + this.encryptionScheme.getClass().getName() + " ...");
        PlainText data = this.plaintextSupplier.get();
        DecryptionKey sk = this.validKeyPair.getSk();
        EncryptionKey pk = this.validKeyPair.getPk();
        CipherText cipherText = this.encryptionScheme.encrypt(data, pk);
        PlainText decryptedCipherText = this.encryptionScheme.decrypt(cipherText, sk);
        Assert.assertEquals((Object)data, (Object)decryptedCipherText);
    }

    @Test
    public void testFailEncryptDecrypt() throws UnsupportedEncodingException {
        System.out.println("Testing invalid encrypt/decrypt for " + this.encryptionScheme.getClass().getName() + " ...");
        PlainText data = this.plaintextSupplier.get();
        DecryptionKey sk = this.invalidKeyPair.getSk();
        EncryptionKey pk = this.invalidKeyPair.getPk();
        CipherText cipherText = this.encryptionScheme.encrypt(data, pk);
        try {
            PlainText decryptedCipherText = this.encryptionScheme.decrypt(cipherText, sk);
            Assert.assertNotEquals((Object)data, (Object)decryptedCipherText);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<TestParams> data() {
        ArrayList<TestParams> schemes = new ArrayList<TestParams>();
        schemes.add(ElgamalParams.getParams());
        return schemes;
    }
}

