/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.params;

import java.math.BigInteger;
import java.util.function.Supplier;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKeyPair;
import org.cryptimeleon.craco.enc.EncryptionScheme;
import org.cryptimeleon.craco.enc.TestParams;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalEncryption;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalPrivateKey;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalPublicKey;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.RingGroup;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class ElgamalParams {
    public static TestParams getParams() {
        Zp zp = new Zp(BigInteger.valueOf(72973L));
        RingGroup zpGroup = zp.asUnitGroup();
        ElgamalEncryption elgamalScheme = new ElgamalEncryption((Group)zpGroup);
        Supplier<PlainText> supplier = () -> ElgamalParams.lambda$getParams$0((Group)zpGroup);
        EncryptionKeyPair validKeyPair = elgamalScheme.generateKeyPair();
        ElgamalPublicKey validPK = (ElgamalPublicKey)validKeyPair.getPk();
        ElgamalPrivateKey validSK = (ElgamalPrivateKey)validKeyPair.getSk();
        Zn expZn = zpGroup.getZn();
        Zn.ZnElement pow = validSK.getA().isOne() ? expZn.valueOf(5L) : expZn.valueOf(1L);
        ElgamalPrivateKey invalidSK = new ElgamalPrivateKey((Group)zpGroup, validSK.getG(), pow);
        EncryptionKeyPair invalidKeyPair = new EncryptionKeyPair((EncryptionKey)validPK, (DecryptionKey)invalidSK);
        return new TestParams((EncryptionScheme)elgamalScheme, supplier, validKeyPair, invalidKeyPair);
    }

    private static /* synthetic */ PlainText lambda$getParams$0(Group zpGroup) {
        return new GroupElementPlainText(zpGroup.getUniformlyRandomElement());
    }
}

