/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.bbs;

import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.bbs.BBSBKeyGen;
import org.cryptimeleon.craco.sig.bbs.BBSBPublicParameter;
import org.cryptimeleon.craco.sig.bbs.BBSBSignatureScheme;
import org.cryptimeleon.math.structures.rings.RingElement;

public class BBSSignatureSchemeTestParamGenerator {
    public static SignatureSchemeParams generateParams(int securityParameter) {
        MessageBlock wrongMessageBlock;
        SignatureKeyPair wrongKeys;
        BBSBKeyGen setup = new BBSBKeyGen();
        BBSBPublicParameter pp = setup.doKeyGen(securityParameter, true);
        BBSBSignatureScheme bbsScheme = new BBSBSignatureScheme(pp);
        SignatureKeyPair keys = bbsScheme.generateKeyPair(2);
        while ((wrongKeys = bbsScheme.generateKeyPair(2)).equals((Object)keys)) {
        }
        MessageBlock messageBlock = new MessageBlock(new PlainText[]{new RingElementPlainText((RingElement)pp.getZp().getUniformlyRandomElement()), new RingElementPlainText((RingElement)pp.getZp().getUniformlyRandomElement())});
        while ((wrongMessageBlock = new MessageBlock(new PlainText[]{new RingElementPlainText((RingElement)pp.getZp().getUniformlyRandomElement()), new RingElementPlainText((RingElement)pp.getZp().getUniformlyRandomElement())})).equals((Object)messageBlock)) {
        }
        return new SignatureSchemeParams((SignatureScheme)bbsScheme, (PublicParameters)pp, (PlainText)messageBlock, (PlainText)wrongMessageBlock, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)keys, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)wrongKeys);
    }
}

