/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps;

import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeTester;
import org.cryptimeleon.craco.sig.ps.PSExtendedSignatureScheme;
import org.cryptimeleon.craco.sig.ps.PSExtendedVerificationKey;
import org.cryptimeleon.craco.sig.ps.PSPublicParameters;
import org.cryptimeleon.craco.sig.ps.PSPublicParametersGen;
import org.cryptimeleon.craco.sig.ps.PSSigningKey;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PSExtendedSignatureSchemeTest {
    private final int NUM_MESSAGES = 2;
    private final int SECURITY_PARAMETER = 260;
    private PSExtendedSignatureScheme psExtendedSignatureScheme;
    private SignatureKeyPair<? extends PSExtendedVerificationKey, ? extends PSSigningKey> keyPair;
    private SignatureKeyPair<? extends PSExtendedVerificationKey, ? extends PSSigningKey> wrongKeyPair;
    private PSPublicParameters pp;
    private MessageBlock messageBlock;
    private MessageBlock wrongMessageBlock;

    @Before
    public void setUp() {
        System.out.println("Setting up public parameters and public key...");
        PSPublicParametersGen ppSetup = new PSPublicParametersGen();
        this.pp = ppSetup.generatePublicParameter(260, true);
        PSExtendedSignatureScheme scheme = new PSExtendedSignatureScheme(this.pp);
        this.keyPair = scheme.generateKeyPair(2);
        do {
            this.wrongKeyPair = scheme.generateKeyPair(2);
        } while (((PSExtendedVerificationKey)this.wrongKeyPair.getVerificationKey()).equals((Object)this.keyPair.getVerificationKey()) || ((PSSigningKey)this.wrongKeyPair.getSigningKey()).equals((Object)this.keyPair.getSigningKey()));
        this.psExtendedSignatureScheme = new PSExtendedSignatureScheme(this.pp);
        RingElementPlainText[] messages = new RingElementPlainText[2];
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = new RingElementPlainText((RingElement)this.pp.getZp().getUniformlyRandomElement());
        }
        this.messageBlock = new MessageBlock((PlainText[])messages);
        RingElementPlainText[] wrongMessages = new RingElementPlainText[2];
        for (int i = 0; i < wrongMessages.length; ++i) {
            do {
                wrongMessages[i] = new RingElementPlainText((RingElement)this.pp.getZp().getUniformlyRandomElement());
            } while (wrongMessages[i].equals((Object)messages[i]));
        }
        this.wrongMessageBlock = new MessageBlock((PlainText[])wrongMessages);
    }

    @Test
    public void testPSSignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testSignatureSchemeSignAndVerify((SignatureScheme)this.psExtendedSignatureScheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
    }

    @Test
    public void testPSSignatureSchemeRepresentationText() {
        SignatureSchemeTester.testRepresentationSignatureScheme((SignatureScheme)this.psExtendedSignatureScheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
        PSPublicParameters ppTest = new PSPublicParameters(this.pp.getRepresentation());
        Assert.assertEquals((Object)this.pp, (Object)ppTest);
    }

    @Test
    public void testNegativeWrongMessagePSSignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testNegativeWrongMessageSignatureSchemeSignAndVerify((SignatureScheme)this.psExtendedSignatureScheme, (PlainText)this.messageBlock, (PlainText)this.wrongMessageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
    }

    @Test
    public void testNegativeWrongKeyPSSignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testNegativeWrongKeysSignatureSchemeSignAndVerify((SignatureScheme)this.psExtendedSignatureScheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey(), this.wrongKeyPair.getVerificationKey(), this.wrongKeyPair.getSigningKey());
    }

    @Test
    public void testMapToPlaintext() {
        SignatureSchemeTester.testMapToPlaintext((SignatureScheme)this.psExtendedSignatureScheme, this.keyPair.getVerificationKey());
    }

    @Test
    public void testMapToPlaintextContract() {
        SignatureSchemeTester.testMapToPlainTextContract((SignatureScheme)this.psExtendedSignatureScheme, this.keyPair);
    }
}

