/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps;

import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SignatureSchemeTester;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.ps.PSPublicParameters;
import org.cryptimeleon.craco.sig.ps.PSSignatureScheme;
import org.cryptimeleon.craco.sig.ps.PSSignatureSchemeTestParamGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PSSignatureSchemeTest {
    private final int NUM_MESSAGES = 2;
    private final int SECURITY_PARAMETER = 160;
    private PSSignatureScheme psScheme;
    private SignatureKeyPair<? extends VerificationKey, ? extends SigningKey> keyPair;
    private SignatureKeyPair<? extends VerificationKey, ? extends SigningKey> wrongKeyPair;
    private PSPublicParameters pp;
    private MessageBlock messageBlock;
    private MessageBlock wrongMessageBlock;

    @Before
    public void setUp() throws Exception {
        SignatureSchemeParams params = PSSignatureSchemeTestParamGenerator.generateParams(160, 2);
        this.psScheme = (PSSignatureScheme)params.getSignatureScheme();
        this.keyPair = params.getKeyPair1();
        this.wrongKeyPair = params.getKeyPair2();
        this.pp = (PSPublicParameters)params.getPublicParameters();
        this.messageBlock = (MessageBlock)params.getMessage1();
        this.wrongMessageBlock = (MessageBlock)params.getMessage2();
    }

    @Test
    public void testPSSignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testSignatureSchemeSignAndVerify((SignatureScheme)this.psScheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
    }

    @Test
    public void testPSSignatureSchemeRepresentationText() {
        SignatureSchemeTester.testRepresentationSignatureScheme((SignatureScheme)this.psScheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
        PSPublicParameters ppTest = new PSPublicParameters(this.pp.getRepresentation());
        Assert.assertEquals((Object)this.pp, (Object)ppTest);
    }

    @Test
    public void testNegativeWrongMessagePSSignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testNegativeWrongMessageSignatureSchemeSignAndVerify((SignatureScheme)this.psScheme, (PlainText)this.messageBlock, (PlainText)this.wrongMessageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
    }

    @Test
    public void testNegativeWrongKeyPSSignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testNegativeWrongKeysSignatureSchemeSignAndVerify((SignatureScheme)this.psScheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey(), this.wrongKeyPair.getVerificationKey(), this.wrongKeyPair.getSigningKey());
    }

    @Test
    public void testMapToPlaintext() {
        SignatureSchemeTester.testMapToPlaintext((SignatureScheme)this.psScheme, this.keyPair.getVerificationKey());
    }

    @Test
    public void testMapToPlaintextContract() {
        SignatureSchemeTester.testMapToPlainTextContract((SignatureScheme)this.psScheme, this.keyPair);
    }
}

