/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.groth15;

import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15PublicParameters;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15PublicParametersGen;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15SignatureScheme;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15SigningKey;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15VerificationKey;

public class SPSGroth15SignatureSchemeTestParamGenerator {
    public static SignatureSchemeParams generateParams(int securityParam, SPSGroth15PublicParametersGen.Groth15Type type, int numberOfMessages) {
        SignatureKeyPair wrongKeyPair;
        SPSGroth15PublicParametersGen ppSetup = new SPSGroth15PublicParametersGen();
        SPSGroth15PublicParameters pp = ppSetup.generatePublicParameter(securityParam, type, numberOfMessages, true);
        SPSGroth15SignatureScheme scheme = new SPSGroth15SignatureScheme(pp);
        SignatureKeyPair keyPair = scheme.generateKeyPair(numberOfMessages);
        while (((SPSGroth15VerificationKey)(wrongKeyPair = scheme.generateKeyPair(numberOfMessages)).getVerificationKey()).equals((Object)keyPair.getVerificationKey()) || ((SPSGroth15SigningKey)wrongKeyPair.getSigningKey()).equals((Object)keyPair.getSigningKey())) {
        }
        GroupElementPlainText[] messages = new GroupElementPlainText[numberOfMessages];
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = new GroupElementPlainText(pp.getPlaintextGroupGenerator().getStructure().getUniformlyRandomElement());
        }
        MessageBlock messageBlock = new MessageBlock((PlainText[])messages);
        GroupElementPlainText[] wrongMessages = new GroupElementPlainText[numberOfMessages];
        for (int i = 0; i < wrongMessages.length; ++i) {
            do {
                wrongMessages[i] = new GroupElementPlainText(pp.getPlaintextGroupGenerator().getStructure().getUniformlyRandomElement());
            } while (wrongMessages[i].equals((Object)messages[i]));
        }
        MessageBlock wrongMessageBlock = new MessageBlock((PlainText[])wrongMessages);
        return new SignatureSchemeParams((SignatureScheme)scheme, (PublicParameters)pp, (PlainText)messageBlock, (PlainText)wrongMessageBlock, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)keyPair, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)wrongKeyPair);
    }
}

