/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc;

import java.lang.reflect.Type;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;

public interface EncryptionScheme
extends StandaloneRepresentable,
RepresentationRestorer {
    public CipherText encrypt(PlainText var1, EncryptionKey var2);

    public PlainText decrypt(CipherText var1, DecryptionKey var2);

    public PlainText restorePlainText(Representation var1);

    public CipherText restoreCipherText(Representation var1);

    public EncryptionKey restoreEncryptionKey(Representation var1);

    public DecryptionKey restoreDecryptionKey(Representation var1);

    default public CipherText encrypt(Representation plainText, Representation publicKey) {
        return this.encrypt(this.restorePlainText(plainText), this.restoreEncryptionKey(publicKey));
    }

    default public PlainText decrypt(Representation cipherText, Representation privateKey) {
        return this.decrypt(this.restoreCipherText(cipherText), this.restoreDecryptionKey(privateKey));
    }

    default public Object restoreFromRepresentation(Type type, Representation repr) {
        if (type instanceof Class) {
            if (EncryptionKey.class.isAssignableFrom((Class)type)) {
                return this.restoreEncryptionKey(repr);
            }
            if (DecryptionKey.class.isAssignableFrom((Class)type)) {
                return this.restoreDecryptionKey(repr);
            }
            if (CipherText.class.isAssignableFrom((Class)type)) {
                return this.restoreCipherText(repr);
            }
            if (PlainText.class.isAssignableFrom((Class)type)) {
                return this.restorePlainText(repr);
            }
        }
        throw new IllegalArgumentException("Cannot restore object of type: " + type.getTypeName());
    }
}

