/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.cryptimeleon.craco.common.utils.StreamUtil;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.EncryptionScheme;

public interface StreamingEncryptionScheme
extends EncryptionScheme {
    default public void encrypt(InputStream plainTextIn, OutputStream cipherTextOut, EncryptionKey publicKey) throws IOException {
        InputStream cipherTextIn = this.encrypt(plainTextIn, publicKey);
        StreamUtil.copy(cipherTextIn, cipherTextOut);
    }

    default public void decrypt(InputStream cipherTextIn, OutputStream plainTextOut, DecryptionKey privateKey) throws IOException {
        InputStream plainTextIn = this.decrypt(cipherTextIn, privateKey);
        StreamUtil.copy(plainTextIn, plainTextOut);
    }

    public InputStream encrypt(InputStream var1, EncryptionKey var2) throws IOException;

    public OutputStream createEncryptor(OutputStream var1, EncryptionKey var2) throws IOException;

    public InputStream decrypt(InputStream var1, DecryptionKey var2) throws IOException;

    public OutputStream createDecryptor(OutputStream var1, DecryptionKey var2) throws IOException;
}

