/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.damgardtechnique;

import org.cryptimeleon.craco.commitment.Commitment;
import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;

class DamgardAnnouncement
implements Announcement {
    @UniqueByteRepresented
    @Represented(restorer="com")
    private Commitment commitmentValue;

    public DamgardAnnouncement(Commitment commitmentValue) {
        this.commitmentValue = commitmentValue;
    }

    public DamgardAnnouncement(Representation representation, CommitmentScheme commitmentScheme) {
        new ReprUtil((Object)this).register((RepresentationRestorer)commitmentScheme, "com").deserialize(representation);
    }

    public Commitment getCommitment() {
        return this.commitmentValue;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DamgardAnnouncement that = (DamgardAnnouncement)o;
        return this.getCommitment() != null ? this.getCommitment().equals(that.getCommitment()) : that.getCommitment() == null;
    }

    public int hashCode() {
        return this.getCommitment() != null ? this.getCommitment().hashCode() : 0;
    }
}

