/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.craco.protocols.arguments.sigma.Challenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.ChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallenge;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZn;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class ZnChallengeSpace
implements ChallengeSpace {
    protected Zn zn;

    public ZnChallengeSpace(Zn zn) {
        this.zn = zn;
    }

    public ZnChallengeSpace(BigInteger size) {
        this.zn = new Zn(size);
    }

    @Override
    public ZnChallenge generateRandomChallenge() {
        return new ZnChallenge(this.zn.getUniformlyRandomElement());
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.zn.size();
    }

    @Override
    public ZnChallenge restoreChallenge(Representation repr) {
        return new ZnChallenge(this.zn.restoreElement(repr));
    }

    @Override
    public ZnChallenge mapIntoChallengeSpace(byte[] bytes) {
        return new ZnChallenge(this.zn.valueOf(bytes));
    }

    @Override
    public ZnChallenge hashIntoChallengeSpace(byte[] bytes) {
        return new ZnChallenge(new HashIntoZn(this.zn).hash(bytes));
    }

    @Override
    public Challenge subtract(Challenge challengeToSplit, Challenge share1) throws UnsupportedOperationException {
        return new ZnChallenge(((ZnChallenge)challengeToSplit).challenge.sub((Element)((ZnChallenge)share1).challenge));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZnChallengeSpace that = (ZnChallengeSpace)o;
        return this.zn.equals((Object)that.zn);
    }

    public int hashCode() {
        return Objects.hash(this.zn);
    }
}

