/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables;

import java.math.BigInteger;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariable;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableValue;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableValueHierarchy;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.VariableExpression;

public interface SchnorrVariableAssignment
extends Substitution,
SecretInput {
    public static final SchnorrVariableAssignment EMPTY = new EmptyAssignment();

    public SchnorrVariableValue getValue(SchnorrVariable var1);

    default public Expression getSubstitution(VariableExpression variable) {
        if (!(variable instanceof SchnorrVariable)) {
            return null;
        }
        SchnorrVariableValue val = this.getValue((SchnorrVariable)variable);
        if (val == null) {
            return null;
        }
        return val.asExpression();
    }

    default public SchnorrVariableAssignment fallbackTo(SchnorrVariableAssignment fallback) {
        return new SchnorrVariableValueHierarchy(this, fallback);
    }

    default public SchnorrVariableAssignment evalLinear(final BigInteger challenge, final SchnorrVariableAssignment random) {
        return new SchnorrVariableAssignment(){

            @Override
            public SchnorrVariableValue getValue(SchnorrVariable variable) {
                return SchnorrVariableAssignment.this.getValue(variable).evalLinear(challenge, random.getValue(variable));
            }
        };
    }

    public static class EmptyAssignment
    implements SchnorrVariableAssignment {
        private EmptyAssignment() {
        }

        @Override
        public SchnorrVariableValue getValue(SchnorrVariable variable) {
            return null;
        }
    }
}

