/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing.accessstructure.utils;

import java.util.ArrayList;
import java.util.HashMap;
import org.cryptimeleon.craco.common.policies.BooleanPolicy;
import org.cryptimeleon.craco.common.policies.Policy;
import org.cryptimeleon.craco.common.policies.PolicyFact;
import org.cryptimeleon.craco.common.policies.ThresholdPolicy;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.InnerNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.LeafNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.TreeNode;

public class PolicyToTreeNodeConverter {
    private final HashMap<Integer, PolicyFact> shareReceivers = new HashMap();
    private final TreeNode tree;

    public PolicyToTreeNodeConverter(Policy policy) {
        this.tree = this.policyToThresholdTree(policy);
    }

    public HashMap<Integer, PolicyFact> getShareReceiverMap() {
        return this.shareReceivers;
    }

    public TreeNode getTree() {
        return this.tree;
    }

    private TreeNode policyToThresholdTree(Policy policy) {
        if (policy == null) {
            return null;
        }
        if (policy instanceof PolicyFact) {
            int shareIdentifier = this.shareReceivers.keySet().stream().mapToInt(Integer::intValue).max().orElse(-1) + 1;
            this.shareReceivers.put(shareIdentifier, (PolicyFact)((Object)policy));
            return new LeafNode(shareIdentifier);
        }
        if (policy instanceof ThresholdPolicy) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>();
            for (Policy child : ((ThresholdPolicy)policy).getChildren()) {
                children.add(this.policyToThresholdTree(child));
            }
            return new InnerNode(children, ((ThresholdPolicy)policy).getThreshold());
        }
        if (policy instanceof BooleanPolicy) {
            BooleanPolicy booleanPolicy = (BooleanPolicy)policy;
            ArrayList<TreeNode> children = new ArrayList<TreeNode>();
            for (Policy child : booleanPolicy.getChildren()) {
                children.add(this.policyToThresholdTree(child));
            }
            if (booleanPolicy.getOperator() == BooleanPolicy.BooleanOperator.AND) {
                return new InnerNode(children, children.size());
            }
            return new InnerNode(children, 1);
        }
        throw new IllegalArgumentException("unexpected type " + policy.getClass().getName() + " for policy");
    }
}

