/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing.shamir;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cryptimeleon.craco.common.policies.Policy;
import org.cryptimeleon.craco.common.policies.ThresholdPolicy;
import org.cryptimeleon.craco.secretsharing.LinearSecretSharing;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.NoSatisfyingSet;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.WrongAccessStructureException;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.polynomial.PolynomialRing;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class ShamirSecretSharing
implements LinearSecretSharing<Policy> {
    private ThresholdPolicy policy;
    private Zp field;

    public ShamirSecretSharing(ThresholdPolicy policy, Zp field) {
        this.policy = policy;
        this.field = field;
    }

    @Override
    public Map<Integer, Zp.ZpElement> getShares(Zp.ZpElement secret) throws WrongAccessStructureException {
        if (secret == null || !this.field.equals((Object)secret.getStructure())) {
            throw new WrongAccessStructureException(secret + " can not be shared over " + this.field);
        }
        int numberOfChildren = this.policy.getChildren().size();
        RingElement[] coefficients = new RingElement[this.policy.getThreshold()];
        coefficients[0] = secret;
        for (int i = 1; i < coefficients.length; ++i) {
            coefficients[i] = this.field.getUniformlyRandomUnit();
        }
        PolynomialRing.Polynomial polynomial = PolynomialRing.getPoly((RingElement[])coefficients);
        HashMap<Integer, Zp.ZpElement> shares = new HashMap<Integer, Zp.ZpElement>(numberOfChildren);
        for (int i = 1; i <= numberOfChildren; ++i) {
            Zp.ZpElement element = this.field.createZnElement(BigInteger.valueOf(i));
            shares.put(i, (Zp.ZpElement)polynomial.evaluate((Element)element));
        }
        return shares;
    }

    @Override
    public Map<Integer, Zp.ZpElement> getSolvingVector(Set<? extends Policy> setOfShareReceivers) throws NoSatisfyingSet, WrongAccessStructureException {
        if (!this.isQualified(setOfShareReceivers)) {
            throw new NoSatisfyingSet();
        }
        return this.getSolvingVector((Collection<Integer>)this.getSharesOfReceivers(setOfShareReceivers));
    }

    @Override
    private Map<Integer, Zp.ZpElement> getSolvingVector(Collection<Integer> shareReceiverIds) throws NoSatisfyingSet, WrongAccessStructureException {
        HashMap<Integer, Zp.ZpElement> solvingVector = new HashMap<Integer, Zp.ZpElement>(shareReceiverIds.size());
        for (int i : shareReceiverIds) {
            Zp.ZpElement numerator = this.field.getOneElement();
            Zp.ZpElement denominator = this.field.getOneElement();
            for (int j : shareReceiverIds) {
                if (i == j) continue;
                Zp.ZpElement xi = this.field.createZnElement(BigInteger.valueOf(i));
                Zp.ZpElement xj = this.field.createZnElement(BigInteger.valueOf(j));
                numerator = numerator.mul((Element)xj.neg());
                denominator = denominator.mul((Element)xi.add((Element)xj.neg()));
            }
            solvingVector.put(i, numerator.mul((Element)denominator.inv()));
        }
        return solvingVector;
    }

    @Override
    public Map<Integer, Policy> getShareReceiverMap() {
        int numberOfChildren = this.policy.getChildren().size();
        HashMap<Integer, Policy> shareReceiver = new HashMap<Integer, Policy>(numberOfChildren);
        for (int i = 1; i <= numberOfChildren; ++i) {
            shareReceiver.put(i, this.policy.getChildren().get(i - 1));
        }
        return shareReceiver;
    }

    @Override
    public boolean isQualified(Set<? extends Policy> setOfShareReceivers) throws WrongAccessStructureException {
        Set<Integer> shares = this.getSharesOfReceivers(setOfShareReceivers);
        return shares.size() >= this.policy.getThreshold();
    }

    @Override
    public Zp getSharedRing() {
        return this.field;
    }

    @Override
    public Map<Integer, Zp.ZpElement> completeShares(Zp.ZpElement secret, Map<Integer, Zp.ZpElement> partialShares) {
        int numberOfShares = this.policy.getChildren().size();
        int numberOfAdditionalCoeff = this.policy.getThreshold() - partialShares.size() - 1;
        HashMap<Integer, Zp.ZpElement> fullShares = new HashMap<Integer, Zp.ZpElement>(partialShares);
        int[] missingIndices = IntStream.rangeClosed(1, numberOfShares).filter(index -> !partialShares.containsKey(index)).toArray();
        for (int i = 0; i < numberOfAdditionalCoeff; ++i) {
            Zp.ZpElement element = this.field.getUniformlyRandomUnit();
            fullShares.put(missingIndices[i], element);
        }
        Map<Zp.ZpElement, Zp.ZpElement> dataPoints = this.collectDataPointsFromShares(fullShares);
        dataPoints.put(this.field.getZeroElement(), secret);
        PolynomialRing.Polynomial polynomial = PolynomialRing.getPoly(dataPoints, (int)(this.policy.getThreshold() - 1));
        for (int i : missingIndices = IntStream.rangeClosed(1, numberOfShares).filter(index -> !fullShares.containsKey(index)).toArray()) {
            Zp.ZpElement element = this.field.createZnElement(BigInteger.valueOf(i));
            fullShares.put(i, (Zp.ZpElement)polynomial.evaluate((Element)element));
        }
        return fullShares;
    }

    private Map<Zp.ZpElement, Zp.ZpElement> collectDataPointsFromShares(Map<Integer, Zp.ZpElement> shares) {
        return shares.entrySet().stream().collect(Collectors.toMap(entry -> this.field.createZnElement(BigInteger.valueOf(((Integer)entry.getKey()).intValue())), Map.Entry::getValue));
    }

    @Override
    public boolean checkShareConsistency(Zp.ZpElement secret, Map<Integer, Zp.ZpElement> shares) {
        if (shares.size() < this.policy.getThreshold()) {
            throw new IllegalArgumentException("Not enough shares to reconstruct secret");
        }
        Map<Integer, Zp.ZpElement> minimalQualifiedShares = shares.entrySet().stream().limit(this.policy.getThreshold()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Zp.ZpElement reconstructedSecret = this.reconstruct(minimalQualifiedShares);
        if (!reconstructedSecret.equals((Object)secret)) {
            return false;
        }
        Map<Zp.ZpElement, Zp.ZpElement> dataPoints = this.collectDataPointsFromShares(minimalQualifiedShares);
        PolynomialRing.Polynomial polynomial = PolynomialRing.getPoly(dataPoints, (int)(this.policy.getThreshold() - 1));
        for (Map.Entry<Integer, Zp.ZpElement> entry : shares.entrySet()) {
            Zp.ZpElement element = this.field.createZnElement(BigInteger.valueOf(entry.getKey().intValue()));
            Zp.ZpElement interpolation = (Zp.ZpElement)polynomial.evaluate((Element)element);
            if (interpolation.equals((Object)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShamirSecretSharing that = (ShamirSecretSharing)o;
        return Objects.equals(this.policy, that.policy) && Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.policy, this.field);
    }
}

