/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.groth15;

import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15PublicParameters;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigBilinearGroup;

public class SPSGroth15PublicParametersGen {
    public SPSGroth15PublicParameters generatePublicParameter(int securityParameter, Groth15Type type, int numberOfMessages, boolean debugMode) {
        Object group = debugMode ? new DebugBilinearGroup(RandomGenerator.getRandomPrime((int)securityParameter), BilinearGroup.Type.TYPE_3) : new BarretoNaehrigBilinearGroup(securityParameter);
        return this.generatePublicParameter((BilinearGroup)group, type, numberOfMessages);
    }

    public SPSGroth15PublicParameters generatePublicParameter(BilinearGroup bilinearGroup, Groth15Type type, int numberOfMessages) {
        return new SPSGroth15PublicParameters(bilinearGroup, type, numberOfMessages);
    }

    public static enum Groth15Type {
        type1,
        type2;

    }
}

