package org.cryptimeleon.craco.sig.sps.akot15.fsp2;

import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15CommitmentKey;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15XSIGCommitmentKey;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGVerificationKey;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;

import java.util.Objects;

/**
 * A verification key as generated by the {@link SPSFSP2SignatureScheme}.
 *
 */
public class SPSFSP2VerificationKey implements VerificationKey {

    /**
     * The verification key used by the building block
     * {@link org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGSignatureScheme}
     */
    @Represented
    protected SPSXSIGVerificationKey vkXSIG;

    /**
     * The commitment key used by the building block
     * {@link org.cryptimeleon.craco.sig.sps.akot15.tc.TCAKOT15CommitmentScheme}
     */
    @Represented
    protected TCGAKOT15CommitmentKey ckTC;


    public SPSFSP2VerificationKey(SPSXSIGVerificationKey vkXSIG, TCGAKOT15CommitmentKey ckTC) {
        this.vkXSIG = vkXSIG;
        this.ckTC = ckTC;
    }

    public SPSFSP2VerificationKey(Group g1, Group g2, Representation repr) {

        ObjectRepresentation objRepr = (ObjectRepresentation) repr;

        this.vkXSIG = new SPSXSIGVerificationKey(g1,g2, objRepr.get("vkXSIG"));
        this.ckTC = new TCGAKOT15XSIGCommitmentKey(g2, objRepr.get("ckTC"));
    }


    @Override
    public Representation getRepresentation() {

        ObjectRepresentation objRepr = new ObjectRepresentation();

        objRepr.put("vkXSIG", vkXSIG.getRepresentation());
        objRepr.put("ckTC", ckTC.getRepresentation());

        return objRepr;
    }

    public SPSXSIGVerificationKey getVkXSIG() {
        return vkXSIG;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SPSFSP2VerificationKey that = (SPSFSP2VerificationKey) o;
        return Objects.equals(vkXSIG, that.vkXSIG) && Objects.equals(ckTC, that.ckTC);
    }

    @Override
    public int hashCode() {
        return Objects.hash(vkXSIG, ckTC);
    }

}
