package org.cryptimeleon.craco.sig.sps.akot15.xsig;

import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

import java.util.Objects;

/**
 * A verification key as generated by the {@link SPSXSIGSignatureScheme}.
 *
 */
public class SPSXSIGVerificationKey implements VerificationKey {

    /**
     * V^{tilde}_1 \in G_2 in the paper
     */
    @Represented(restorer = "G2")
    protected GroupElement group2ElementV1;

    /**
     * V^{tilde}_2 \in G_2 in the paper
     */
    @Represented(restorer = "G2")
    protected GroupElement group2ElementV2;

    /**
     * V^{tilde}_3 \in G_2 in the paper
     */
    @Represented(restorer = "G2")
    protected GroupElement group2ElementV3;

    /**
     * V^{tilde}_4 \in G_2 in the paper
     */
    @Represented(restorer = "G2")
    protected GroupElement group2ElementV4;

    /**
     * V^{tilde}_5 \in G_2 in the paper
     */
    @Represented(restorer = "G2")
    protected GroupElement group2ElementV5;

    /**
     * V^{tilde}_6 \in G_2 in the paper
     */
    @Represented(restorer = "G2")
    protected GroupElement group2ElementV6;

    /**
     * V_7 \in G_1(!) in the paper
     */
    @Represented(restorer = "G1") //note: V7 is in Group G_1
    protected GroupElement group1ElementV7;

    /**
     * V^{tilde}_8 \in G_2 in the paper
     */
    @Represented(restorer = "G2")
    protected GroupElement group2ElementV8;


    public SPSXSIGVerificationKey(GroupElement group2ElementV1, GroupElement group2ElementV2,
                                  GroupElement group2ElementV3, GroupElement group2ElementV4,
                                  GroupElement group2ElementV5, GroupElement group2ElementV6,
                                  GroupElement group1ElementV7, GroupElement group2ElementV8) {

        this.group2ElementV1 = group2ElementV1;
        this.group2ElementV2 = group2ElementV2;
        this.group2ElementV3 = group2ElementV3;
        this.group2ElementV4 = group2ElementV4;
        this.group2ElementV5 = group2ElementV5;
        this.group2ElementV6 = group2ElementV6;
        this.group1ElementV7 = group1ElementV7;
        this.group2ElementV8 = group2ElementV8;
    }

    public SPSXSIGVerificationKey(Group G1, Group G2, Representation repr){
        new ReprUtil(this).register(G1, "G1").register(G2, "G2").deserialize(repr);
    }


    public GroupElement getGroup2ElementV1() {
        return group2ElementV1;
    }

    public GroupElement getGroup2ElementV2() {
        return group2ElementV2;
    }

    public GroupElement getGroup2ElementV3() {
        return group2ElementV3;
    }

    public GroupElement getGroup2ElementV4() {
        return group2ElementV4;
    }

    public GroupElement getGroup2ElementV5() {
        return group2ElementV5;
    }

    public GroupElement getGroup2ElementV6() {
        return group2ElementV6;
    }

    public GroupElement getGroup1ElementV7() {
        return group1ElementV7;
    }

    public GroupElement getGroup2ElementV8() {
        return group2ElementV8;
    }


    @Override
    public Representation getRepresentation() { return ReprUtil.serialize(this); }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SPSXSIGVerificationKey that = (SPSXSIGVerificationKey) o;
        return Objects.equals(group2ElementV1, that.group2ElementV1)
                && Objects.equals(group2ElementV2, that.group2ElementV2)
                && Objects.equals(group2ElementV3, that.group2ElementV3)
                && Objects.equals(group2ElementV4, that.group2ElementV4)
                && Objects.equals(group2ElementV5, that.group2ElementV5)
                && Objects.equals(group2ElementV6, that.group2ElementV6)
                && Objects.equals(group1ElementV7, that.group1ElementV7)
                && Objects.equals(group2ElementV8, that.group2ElementV8);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                group2ElementV1, group2ElementV2,
                group2ElementV3, group2ElementV4,
                group2ElementV5, group2ElementV6,
                group1ElementV7, group2ElementV8);
    }

}
