/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.commitment;

import java.util.Arrays;
import org.cryptimeleon.craco.commitment.CommitmentPair;
import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.commitment.pedersen.PedersenCommitmentScheme;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.debug.DebugGroup;
import org.junit.Assert;

public class CommitmentSchemeTester {
    public static void testCommitmentSchemeVerify(CommitmentScheme commitmentScheme, PlainText message) {
        CommitmentPair commitmentPair = commitmentScheme.commit(message);
        Assert.assertTrue((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair.getOpenValue(), message));
    }

    public static void testCommitmentSchemeVerifyWithWrongMessages(CommitmentScheme commitmentScheme, PlainText originalMessage, PlainText wrongMessage) {
        CommitmentPair commitmentPair = commitmentScheme.commit(originalMessage);
        CommitmentPair commitmentPair2 = commitmentScheme.commit(wrongMessage);
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair.getOpenValue(), wrongMessage));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair2.getOpenValue(), wrongMessage));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair.getCommitment(), commitmentPair2.getOpenValue(), originalMessage));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair2.getCommitment(), commitmentPair.getOpenValue(), wrongMessage));
        Assert.assertFalse((boolean)commitmentScheme.verify(commitmentPair2.getCommitment(), commitmentPair2.getOpenValue(), originalMessage));
    }

    public static void testCommitmentSchemeMapToPlaintext(CommitmentScheme commitmentScheme) {
        byte[] randomBytes2;
        byte[] randomBytes1 = RandomGenerator.getRandomBytes((int)commitmentScheme.getMaxNumberOfBytesForMapToPlaintext());
        while (Arrays.equals(randomBytes1, randomBytes2 = RandomGenerator.getRandomBytes((int)commitmentScheme.getMaxNumberOfBytesForMapToPlaintext()))) {
        }
        Assert.assertNotEquals((Object)commitmentScheme.mapToPlaintext(randomBytes1), (Object)commitmentScheme.mapToPlaintext(randomBytes2));
    }

    public static void main(String[] args) {
        DebugGroup g = new DebugGroup("test", RandomGenerator.getRandomPrime((int)80));
        PedersenCommitmentScheme ped = new PedersenCommitmentScheme((Group)g, 10);
        CommitmentSchemeTester.testCommitmentSchemeMapToPlaintext((CommitmentScheme)ped);
    }
}

