/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.representation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.EncryptionScheme;
import org.cryptimeleon.craco.enc.representation.ElgamalParams;
import org.cryptimeleon.craco.enc.representation.RepresentationTestParams;
import org.cryptimeleon.math.serialization.Representation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RepresentationTest {
    protected EncryptionScheme scheme;
    protected EncryptionKey encryptionKey;
    protected DecryptionKey decryptionKey;
    protected PlainText plainText;
    protected CipherText cipherText;

    public RepresentationTest(RepresentationTestParams params) {
        this.scheme = params.scheme;
        this.encryptionKey = params.encryptionKey;
        this.decryptionKey = params.decryptionKey;
        this.plainText = params.plainText;
        this.cipherText = params.cipherText;
    }

    @Test
    public void testRepresentation() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        System.out.println("Testing " + this.scheme.toString());
        EncryptionScheme toCompare = (EncryptionScheme)this.scheme.getClass().getConstructor(Representation.class).newInstance(this.scheme.getRepresentation());
        System.out.println("Testing the standalone property of the scheme...");
        Assert.assertEquals((Object)this.scheme, (Object)toCompare);
        System.out.println("Testing the deserialization of an EncryptionKey...");
        Assert.assertEquals((Object)this.encryptionKey, (Object)this.scheme.restoreEncryptionKey(this.encryptionKey.getRepresentation()));
        System.out.println("Testing the deserialization of a DecryptionKey...");
        Assert.assertEquals((Object)this.decryptionKey, (Object)this.scheme.restoreDecryptionKey(this.decryptionKey.getRepresentation()));
        System.out.println("Testing the deserialization of a PlainText...");
        Assert.assertEquals((Object)this.plainText, (Object)this.scheme.restorePlainText(this.plainText.getRepresentation()));
        System.out.println("Testing the deserialization of a CipherText...");
        Assert.assertEquals((Object)this.cipherText, (Object)this.scheme.restoreCipherText(this.cipherText.getRepresentation()));
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<RepresentationTestParams> data() {
        ArrayList<RepresentationTestParams> toReturn = new ArrayList<RepresentationTestParams>();
        toReturn.add(ElgamalParams.getParams());
        return toReturn;
    }
}

