/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols;

import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.ProtocolsTest;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.DelegateProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.LinearStatementFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SchnorrFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SendThenDelegateFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership.SetMembershipPublicParameters;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership.SmallerThanPowerFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership.TwoSidedRangeProof;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrZnVariable;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.junit.jupiter.api.Test;

public class SchnorrTest
extends ProtocolsTest {
    @Test
    public void testBasicSchnorr() {
        this.runTests(SchnorrTest.getSimpleSchnorrProof(), SchnorrTest.getSimpleSchnorrProofInput(), SchnorrTest.getSimpleSchnorrProofWitness());
    }

    @Test
    public void testCommittedRangeProof() {
        final GroupElement g = bilGroup.getG1().getGenerator();
        final GroupElement h = bilGroup.getG1().getUniformlyRandomNonNeutral();
        final Zn.ZnElement m = bilGroup.getG1().getZn().valueOf(20L);
        final Zn.ZnElement r = bilGroup.getG1().getUniformlyRandomExponent();
        final GroupElement C = g.pow(m).op((Element)h.pow(r));
        final SetMembershipPublicParameters setMembershipPublicParameters = SmallerThanPowerFragment.generatePublicParameters((BilinearGroup)bilGroup, (int)2);
        DelegateProtocol protocol = new DelegateProtocol(){

            public ZnChallengeSpace getChallengeSpace(CommonInput commonInput) {
                return new ZnChallengeSpace(ProtocolsTest.bilGroup.getZn());
            }

            protected SendThenDelegateFragment.ProverSpec provideProverSpecWithNoSendFirst(CommonInput commonInput, SecretInput secretInput, SendThenDelegateFragment.ProverSpecBuilder builder) {
                builder.putWitnessValue("m", m);
                builder.putWitnessValue("r", r);
                return builder.build();
            }

            protected SendThenDelegateFragment.SubprotocolSpec provideSubprotocolSpec(CommonInput commonInput, SendThenDelegateFragment.SubprotocolSpecBuilder builder) {
                SchnorrZnVariable mVar = builder.addZnVariable("m", ProtocolsTest.bilGroup.getG1().getZn());
                SchnorrZnVariable rVar = builder.addZnVariable("r", ProtocolsTest.bilGroup.getG1().getZn());
                builder.addSubprotocol("commitment open", (SchnorrFragment)new LinearStatementFragment(g.pow((ExponentExpr)mVar).op(h.pow((ExponentExpr)rVar)).isEqualTo(C)));
                builder.addSubprotocol("twoSidedRange", (SchnorrFragment)new TwoSidedRangeProof((ExponentExpr)mVar, 13, 23, setMembershipPublicParameters));
                builder.addSubprotocol("oneSidedRange", (SchnorrFragment)new SmallerThanPowerFragment((ExponentExpr)mVar, 2, 5, setMembershipPublicParameters));
                return builder.build();
            }
        };
        this.runTests((SigmaProtocol)protocol);
    }
}

