/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.ser.standalone.params;

import java.math.BigInteger;
import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.commitment.hashthencommit.HashThenCommitCommitmentScheme;
import org.cryptimeleon.craco.commitment.pedersen.PedersenCommitmentScheme;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.akot15.tc.TCAKOT15CommitmentScheme;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15CommitmentScheme;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15XSIGPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGPublicParametersGen;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.SHA256HashFunction;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.standalone.StandaloneReprSubTest;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class CommitmentStandaloneReprTests
extends StandaloneReprSubTest {
    private final int NUMBER_OF_MESSAGES = 3;
    private final Zn zn = new Zn(BigInteger.valueOf(2L).pow(260));
    private final PedersenCommitmentScheme pedersen = new PedersenCommitmentScheme((Group)this.zn.asAdditiveGroup(), 3);

    public void testPedersen() {
        this.test((StandaloneRepresentable)this.pedersen);
    }

    public void testTCGAKOT15() {
        AKOT15SharedPublicParameters pp = AKOT15SharedPublicParametersGen.generateParameters((int)128, (int)20, (boolean)true);
        TCGAKOT15CommitmentScheme scheme = new TCGAKOT15CommitmentScheme(pp);
        this.test((StandaloneRepresentable)pp);
        this.test((StandaloneRepresentable)scheme);
        SPSXSIGPublicParameters ppXSIG = SPSXSIGPublicParametersGen.generatePublicParameters((int)128, (int)20, (boolean)true);
        TCGAKOT15XSIGPublicParameters ppTCGXSIG = new TCGAKOT15XSIGPublicParameters(ppXSIG, 20);
        this.test((StandaloneRepresentable)ppTCGXSIG);
    }

    public void testTCAKOT15() {
        AKOT15SharedPublicParameters pp = AKOT15SharedPublicParametersGen.generateParameters((int)128, (int)20, (boolean)true);
        TCAKOT15CommitmentScheme scheme = new TCAKOT15CommitmentScheme(pp);
        this.test((StandaloneRepresentable)pp);
        this.test((StandaloneRepresentable)scheme);
    }

    public void testHashThenCommit() {
        this.test((StandaloneRepresentable)new HashThenCommitCommitmentScheme((CommitmentScheme)this.pedersen, (HashFunction)new SHA256HashFunction()));
    }
}

