/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.ser.standalone.params;

import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.bbs.BBSBKeyGen;
import org.cryptimeleon.craco.sig.bbs.BBSBPublicParameter;
import org.cryptimeleon.craco.sig.bbs.BBSBSignatureScheme;
import org.cryptimeleon.craco.sig.ecdsa.ECDSASignature;
import org.cryptimeleon.craco.sig.ecdsa.ECDSASignatureScheme;
import org.cryptimeleon.craco.sig.hashthensign.HashThenSign;
import org.cryptimeleon.craco.sig.ps.PSExtendedSignatureScheme;
import org.cryptimeleon.craco.sig.ps.PSPublicParameters;
import org.cryptimeleon.craco.sig.ps.PSPublicParametersGen;
import org.cryptimeleon.craco.sig.ps.PSSignatureScheme;
import org.cryptimeleon.craco.sig.ps18.PS18ROMSignatureScheme;
import org.cryptimeleon.craco.sig.ps18.PS18SignatureScheme;
import org.cryptimeleon.craco.sig.sps.SPSPublicParameters;
import org.cryptimeleon.craco.sig.sps.SPSPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.agho11.SPSAGHO11PublicParameters;
import org.cryptimeleon.craco.sig.sps.agho11.SPSAGHO11PublicParametersGen;
import org.cryptimeleon.craco.sig.sps.agho11.SPSAGHO11SignatureScheme;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.akot15.fsp2.SPSFSP2SignatureScheme;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSignatureScheme;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGSignatureScheme;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQPublicParameters;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQSignatureScheme;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15PublicParameters;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15PublicParametersGen;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15SignatureScheme;
import org.cryptimeleon.craco.sig.sps.kpw15.SPSKPW15PublicParameterGen;
import org.cryptimeleon.craco.sig.sps.kpw15.SPSKPW15PublicParameters;
import org.cryptimeleon.craco.sig.sps.kpw15.SPSKPW15SignatureScheme;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.VariableOutputLengthHashFunction;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.standalone.StandaloneReprSubTest;

public class SignatureStandaloneReprTests
extends StandaloneReprSubTest {
    private final PSPublicParameters pp = new PSPublicParametersGen().generatePublicParameter(128, true);

    public void testECDSA() {
        ECDSASignatureScheme ecdsaSignatureScheme = new ECDSASignatureScheme();
        SignatureKeyPair keyPair = ecdsaSignatureScheme.generateKeyPair();
        ECDSASignature signature = (ECDSASignature)ecdsaSignatureScheme.sign((PlainText)new MessageBlock(new PlainText[]{new ByteArrayImplementation("TestMessage".getBytes())}), keyPair.getSigningKey());
        this.test((StandaloneRepresentable)keyPair.getSigningKey());
        this.test((StandaloneRepresentable)keyPair.getVerificationKey());
        this.test((StandaloneRepresentable)signature);
    }

    public void testSPSEQ() {
        SPSEQPublicParameters pp = new SPSEQPublicParametersGen().generatePublicParameter(128, true);
        SPSEQSignatureScheme signatureScheme = new SPSEQSignatureScheme(pp);
        this.test((StandaloneRepresentable)signatureScheme);
        this.test((StandaloneRepresentable)pp);
    }

    public void testSPSGroth15() {
        SPSGroth15PublicParameters pp = new SPSGroth15PublicParametersGen().generatePublicParameter(128, SPSGroth15PublicParametersGen.Groth15Type.type1, 20, true);
        SPSGroth15SignatureScheme signatureScheme = new SPSGroth15SignatureScheme(pp);
        this.test((StandaloneRepresentable)signatureScheme);
        this.test((StandaloneRepresentable)pp);
        pp = new SPSGroth15PublicParametersGen().generatePublicParameter(128, SPSGroth15PublicParametersGen.Groth15Type.type2, 20, true);
        signatureScheme = new SPSGroth15SignatureScheme(pp);
        this.test((StandaloneRepresentable)signatureScheme);
        this.test((StandaloneRepresentable)pp);
    }

    public void testSPSAGHO11() {
        SPSAGHO11PublicParameters pp = SPSAGHO11PublicParametersGen.generatePublicParameters((int)128, (boolean)true, (Integer[])new Integer[]{20, 20});
        SPSAGHO11SignatureScheme scheme = new SPSAGHO11SignatureScheme(pp);
        this.test((StandaloneRepresentable)scheme);
        this.test((StandaloneRepresentable)pp);
    }

    public void testSPSKPW15() {
        SPSKPW15PublicParameters pp = new SPSKPW15PublicParameterGen().generatePublicParameter(128, true, 20);
        SPSKPW15SignatureScheme scheme = new SPSKPW15SignatureScheme(pp);
        this.test((StandaloneRepresentable)scheme);
        this.test((StandaloneRepresentable)pp);
    }

    public void testPS() {
        this.test((StandaloneRepresentable)this.pp);
        this.test((StandaloneRepresentable)new PSSignatureScheme(this.pp));
        this.test((StandaloneRepresentable)new PSExtendedSignatureScheme(this.pp));
        this.test((StandaloneRepresentable)new PS18ROMSignatureScheme(this.pp));
        this.test((StandaloneRepresentable)new PS18SignatureScheme(this.pp));
        this.test((StandaloneRepresentable)new HashThenSign((HashFunction)new VariableOutputLengthHashFunction((this.pp.getZp().size().bitLength() - 1) / 8), (SignatureScheme)new PSSignatureScheme(this.pp)));
    }

    public void testBBS() {
        BBSBKeyGen setup = new BBSBKeyGen();
        BBSBPublicParameter pp = setup.doKeyGen(80, true);
        this.test((StandaloneRepresentable)pp);
        this.test((StandaloneRepresentable)new BBSBSignatureScheme(pp));
    }

    public void testSPSPublicParameters() {
        SPSPublicParameters pp = SPSPublicParametersGen.generateParameters((int)128, (boolean)true);
        this.test((StandaloneRepresentable)pp);
    }

    public void testPOS() {
        AKOT15SharedPublicParameters pp = AKOT15SharedPublicParametersGen.generateParameters((int)128, (int)20, (boolean)true);
        SPSPOSSignatureScheme scheme = new SPSPOSSignatureScheme(pp);
        this.test((StandaloneRepresentable)scheme);
        this.test((StandaloneRepresentable)pp);
    }

    public void testXSIG() {
        SPSXSIGPublicParameters pp = SPSXSIGPublicParametersGen.generatePublicParameters((int)128, (int)20, (boolean)true);
        SPSXSIGSignatureScheme scheme = new SPSXSIGSignatureScheme(pp);
        this.test((StandaloneRepresentable)scheme);
        this.test((StandaloneRepresentable)pp);
    }

    public void testFSP2() {
        AKOT15SharedPublicParameters pp = AKOT15SharedPublicParametersGen.generateParameters((int)128, (int)20, (boolean)true);
        SPSFSP2SignatureScheme scheme = new SPSFSP2SignatureScheme(pp);
        this.test((StandaloneRepresentable)scheme);
        this.test((StandaloneRepresentable)pp);
    }
}

