/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ecdsa;

import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SignatureSchemeTester;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.ecdsa.ECDSASignatureScheme;
import org.cryptimeleon.craco.sig.ecdsa.ECDSASignatureSchemeTestParamGen;
import org.junit.Before;
import org.junit.Test;

public class ECDSASignatureSchemeTest {
    private ECDSASignatureScheme scheme;
    private SignatureKeyPair<? extends VerificationKey, ? extends SigningKey> keyPair;
    private SignatureKeyPair<? extends VerificationKey, ? extends SigningKey> wrongKeyPair;
    private MessageBlock messageBlock;
    private MessageBlock wrongMessageBlock;

    @Before
    public void setUp() {
        SignatureSchemeParams params = ECDSASignatureSchemeTestParamGen.generateParams();
        this.scheme = (ECDSASignatureScheme)params.getSignatureScheme();
        this.keyPair = params.getKeyPair1();
        this.wrongKeyPair = params.getKeyPair2();
        this.messageBlock = (MessageBlock)params.getMessage1();
        this.wrongMessageBlock = (MessageBlock)params.getMessage2();
    }

    @Test
    public void testSignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testSignatureSchemeSignAndVerify((SignatureScheme)this.scheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
    }

    @Test
    public void testSignatureSchemeRepresentationText() {
        SignatureSchemeTester.testRepresentationSignatureScheme((SignatureScheme)this.scheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
    }

    @Test
    public void testNegativeWrongMessageSignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testNegativeWrongMessageSignatureSchemeSignAndVerify((SignatureScheme)this.scheme, (PlainText)this.messageBlock, (PlainText)this.wrongMessageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
    }

    @Test
    public void testNegativeWrongKeySignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testNegativeWrongKeysSignatureSchemeSignAndVerify((SignatureScheme)this.scheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey(), this.wrongKeyPair.getVerificationKey(), this.wrongKeyPair.getSigningKey());
    }
}

