/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps;

import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.ps.PSPublicParameters;
import org.cryptimeleon.craco.sig.ps.PSPublicParametersGen;
import org.cryptimeleon.craco.sig.ps.PSSignatureScheme;
import org.cryptimeleon.craco.sig.ps.PSSigningKey;
import org.cryptimeleon.craco.sig.ps.PSVerificationKey;
import org.cryptimeleon.math.structures.rings.RingElement;

public class PSSignatureSchemeTestParamGenerator {
    public static SignatureSchemeParams generateParams(int securityParam, int numMessages) {
        SignatureKeyPair wrongKeyPair;
        PSPublicParametersGen ppSetup = new PSPublicParametersGen();
        PSPublicParameters pp = ppSetup.generatePublicParameter(securityParam, true);
        PSSignatureScheme psScheme = new PSSignatureScheme(pp);
        SignatureKeyPair keyPair = psScheme.generateKeyPair(numMessages);
        while (((PSVerificationKey)(wrongKeyPair = psScheme.generateKeyPair(numMessages)).getVerificationKey()).equals((Object)keyPair.getVerificationKey()) || ((PSSigningKey)wrongKeyPair.getSigningKey()).equals((Object)keyPair.getSigningKey())) {
        }
        RingElementPlainText[] messages = new RingElementPlainText[numMessages];
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = new RingElementPlainText((RingElement)pp.getZp().getUniformlyRandomElement());
        }
        MessageBlock messageBlock = new MessageBlock((PlainText[])messages);
        RingElementPlainText[] wrongMessages = new RingElementPlainText[numMessages];
        for (int i = 0; i < wrongMessages.length; ++i) {
            do {
                wrongMessages[i] = new RingElementPlainText((RingElement)pp.getZp().getUniformlyRandomElement());
            } while (wrongMessages[i].equals((Object)messages[i]));
        }
        MessageBlock wrongMessageBlock = new MessageBlock((PlainText[])wrongMessages);
        return new SignatureSchemeParams((SignatureScheme)psScheme, (PublicParameters)pp, (PlainText)messageBlock, (PlainText)wrongMessageBlock, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)keyPair, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)wrongKeyPair);
    }
}

