/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps;

import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SignatureSchemeTester;
import org.junit.Before;
import org.junit.Test;

public abstract class SPSSchemeTester {
    protected static int testIterations = 5;
    protected static int NUM_MESSAGES = 32;
    protected static int SECURITY_PARAMETER = 128;
    protected SignatureSchemeParams params;

    protected abstract SignatureSchemeParams generateParameters();

    @Before
    public void setUp() throws Exception {
        this.params = this.generateParameters();
    }

    @Test
    public void testSignatureAndVerify() {
        for (int i = 0; i < testIterations; ++i) {
            SignatureSchemeTester.testSignatureSchemeSignAndVerify(this.params.getSignatureScheme(), this.params.getMessage1(), this.params.getKeyPair1().getVerificationKey(), this.params.getKeyPair1().getSigningKey());
        }
    }

    @Test
    public void testNegativeSignatureAndVerify() {
        for (int i = 0; i < testIterations; ++i) {
            SignatureSchemeTester.testNegativeWrongKeysSignatureSchemeSignAndVerify(this.params.getSignatureScheme(), this.params.getMessage1(), this.params.getKeyPair1().getVerificationKey(), this.params.getKeyPair1().getSigningKey(), this.params.getKeyPair2().getVerificationKey(), this.params.getKeyPair2().getSigningKey());
        }
    }

    @Test
    public void testSignatureSchemeRepresentationText() {
        SignatureSchemeTester.testRepresentationSignatureScheme(this.params.getSignatureScheme(), this.params.getMessage1(), this.params.getKeyPair1().getVerificationKey(), this.params.getKeyPair1().getSigningKey());
    }

    @Test
    public void testMapToPlaintext() {
        SignatureSchemeTester.testMapToPlaintext(this.params.getSignatureScheme(), this.params.getKeyPair1().getVerificationKey());
    }

    @Test
    public void testMapToPlaintextContract() {
        SignatureSchemeTester.testMapToPlainTextContract(this.params.getSignatureScheme(), this.params.getKeyPair1());
    }

    @Test
    public abstract void testPublicParameterRepresentation();
}

