/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.agho11;

import java.util.Arrays;
import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.agho11.SPSAGHO11PublicParameters;
import org.cryptimeleon.craco.sig.sps.agho11.SPSAGHO11PublicParametersGen;
import org.cryptimeleon.craco.sig.sps.agho11.SPSAGHO11SignatureScheme;
import org.cryptimeleon.craco.sig.sps.agho11.SPSAGHO11SigningKey;
import org.cryptimeleon.craco.sig.sps.agho11.SPSAGHO11VerificationKey;

public class SPSAGHO11SignatureSchemeTestParamGenerator {
    public static SignatureSchemeParams generateParams(int securityParameter, Integer[] messageBlockLengths) {
        SignatureKeyPair wrongKeyPair;
        SPSAGHO11PublicParametersGen ppSetup = new SPSAGHO11PublicParametersGen();
        SPSAGHO11PublicParameters pp = SPSAGHO11PublicParametersGen.generatePublicParameters((int)securityParameter, (boolean)true, (Integer[])messageBlockLengths);
        SPSAGHO11SignatureScheme scheme = new SPSAGHO11SignatureScheme(pp);
        int[] msgBlockLengths = Arrays.stream(messageBlockLengths).mapToInt(i -> i).toArray();
        SignatureKeyPair keyPair = scheme.generateKeyPair(msgBlockLengths);
        while (((SPSAGHO11VerificationKey)(wrongKeyPair = scheme.generateKeyPair(msgBlockLengths)).getVerificationKey()).equals((Object)keyPair.getVerificationKey()) || ((SPSAGHO11SigningKey)wrongKeyPair.getSigningKey()).equals((Object)keyPair.getSigningKey())) {
        }
        MessageBlock[] testMessages = SPSAGHO11SignatureSchemeTestParamGenerator.generateMessageBlocks(pp, messageBlockLengths);
        return new SignatureSchemeParams((SignatureScheme)scheme, (PublicParameters)pp, (PlainText)testMessages[0], (PlainText)testMessages[1], (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)keyPair, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)wrongKeyPair);
    }

    private static MessageBlock[] generateMessageBlocks(SPSAGHO11PublicParameters pp, Integer[] messageBlockLengths) {
        MessageBlock[] groupElementVectors = new MessageBlock[2];
        for (int i = 0; i < 2; ++i) {
            GroupElementPlainText[] innerBlock = new GroupElementPlainText[messageBlockLengths[i].intValue()];
            for (int j = 0; j < messageBlockLengths[i]; ++j) {
                innerBlock[j] = i == 0 ? new GroupElementPlainText(pp.getG1GroupGenerator().getStructure().getUniformlyRandomElement()) : new GroupElementPlainText(pp.getG2GroupGenerator().getStructure().getUniformlyRandomElement());
            }
            groupElementVectors[i] = new MessageBlock((PlainText[])innerBlock);
        }
        MessageBlock[] wrongGroupElementVectors = new MessageBlock[2];
        for (int i = 0; i < 2; ++i) {
            GroupElementPlainText[] wrongInnerBlock = new GroupElementPlainText[messageBlockLengths[i].intValue()];
            for (int j = 0; j < messageBlockLengths[i]; ++j) {
                do {
                    wrongInnerBlock[j] = i == 0 ? new GroupElementPlainText(pp.getG1GroupGenerator().getStructure().getUniformlyRandomElement()) : new GroupElementPlainText(pp.getG2GroupGenerator().getStructure().getUniformlyRandomElement());
                } while (wrongInnerBlock[j].equals(groupElementVectors[i].get(j)));
            }
            wrongGroupElementVectors[i] = new MessageBlock((PlainText[])wrongInnerBlock);
        }
        return new MessageBlock[]{new MessageBlock((PlainText[])groupElementVectors), new MessageBlock((PlainText[])wrongGroupElementVectors)};
    }
}

