/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15;

import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.akot15.fsp2.SPSFSP2SignatureScheme;
import org.cryptimeleon.craco.sig.sps.akot15.fsp2.SPSFSP2VerificationKey;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGSigningKey;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class SPSAKOT15SignatureSchemeTestParameterGenerator {
    public static SignatureSchemeParams generateParameters(int securityParameter, int messageLength) {
        SignatureKeyPair wrongKeyPair;
        AKOT15SharedPublicParameters pp = AKOT15SharedPublicParametersGen.generateParameters((int)securityParameter, (int)messageLength, (boolean)true);
        SPSFSP2SignatureScheme scheme = new SPSFSP2SignatureScheme(pp);
        SignatureKeyPair keyPair = scheme.generateKeyPair(messageLength);
        while (((SPSFSP2VerificationKey)(wrongKeyPair = scheme.generateKeyPair(messageLength)).getVerificationKey()).equals((Object)keyPair.getVerificationKey()) || ((SPSXSIGSigningKey)wrongKeyPair.getSigningKey()).equals((Object)keyPair.getSigningKey())) {
        }
        GroupElementPlainText[] messages = new GroupElementPlainText[messageLength];
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = new GroupElementPlainText(pp.getG2GroupGenerator().pow((Zn.ZnElement)pp.getZp().getUniformlyRandomElement()).compute());
        }
        GroupElementPlainText[] wrongMessages = new GroupElementPlainText[messageLength];
        for (int i = 0; i < wrongMessages.length; ++i) {
            do {
                wrongMessages[i] = new GroupElementPlainText(pp.getG2GroupGenerator().pow((Zn.ZnElement)pp.getZp().getUniformlyRandomElement()).compute());
            } while (wrongMessages[i].equals((Object)messages[i]));
        }
        return new SignatureSchemeParams((SignatureScheme)scheme, (PublicParameters)pp, (PlainText)new MessageBlock((PlainText[])messages), (PlainText)new MessageBlock((PlainText[])wrongMessages), (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)keyPair, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)wrongKeyPair);
    }
}

