/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.pos;

import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSignatureScheme;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSigningKey;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSVerificationKey;

public class SPSPOSSignatureSchemeTestParamGenerator {
    public static SignatureSchemeParams generateParameters(int securityParameter, int numberOfMessages) {
        SignatureKeyPair wrongKeyPair;
        AKOT15SharedPublicParameters pp = AKOT15SharedPublicParametersGen.generateParameters((int)securityParameter, (int)numberOfMessages, (boolean)true);
        SPSPOSSignatureScheme scheme = new SPSPOSSignatureScheme(pp);
        SignatureKeyPair keyPair = scheme.generateKeyPair(numberOfMessages);
        while (((SPSPOSVerificationKey)(wrongKeyPair = scheme.generateKeyPair(numberOfMessages)).getVerificationKey()).equals((Object)keyPair.getVerificationKey()) || ((SPSPOSSigningKey)wrongKeyPair.getSigningKey()).equals((Object)keyPair.getSigningKey())) {
        }
        GroupElementPlainText[] messages = new GroupElementPlainText[numberOfMessages];
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = new GroupElementPlainText(pp.getG2GroupGenerator().getStructure().getUniformlyRandomElement());
        }
        GroupElementPlainText[] wrongMessages = new GroupElementPlainText[numberOfMessages];
        for (int i = 0; i < wrongMessages.length; ++i) {
            do {
                wrongMessages[i] = new GroupElementPlainText(pp.getG2GroupGenerator().getStructure().getUniformlyRandomElement());
            } while (wrongMessages[i].equals((Object)messages[i]));
        }
        return new SignatureSchemeParams((SignatureScheme)scheme, (PublicParameters)pp, (PlainText)new MessageBlock((PlainText[])messages), (PlainText)new MessageBlock((PlainText[])wrongMessages), (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)keyPair, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)wrongKeyPair);
    }
}

