/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.pos;

import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SignatureSchemeTester;
import org.cryptimeleon.craco.sig.sps.SPSSchemeTester;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSignature;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSignatureScheme;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSignatureSchemeTestParamGenerator;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;
import org.junit.Assert;
import org.junit.Test;

public class SPSPOSSignatureSchemeTests
extends SPSSchemeTester {
    @Override
    protected SignatureSchemeParams generateParameters() {
        return SPSPOSSignatureSchemeTestParamGenerator.generateParameters(SECURITY_PARAMETER, NUM_MESSAGES);
    }

    @Override
    public void testSignatureAndVerify() {
        for (int i = 0; i < testIterations; ++i) {
            SignatureSchemeTester.testSignatureSchemeSignAndVerify(this.params.getSignatureScheme(), this.params.getMessage1(), this.params.getKeyPair1().getVerificationKey(), this.params.getKeyPair1().getSigningKey());
            ((SPSPOSSignatureScheme)this.params.getSignatureScheme()).updateOneTimeKey(this.params.getKeyPair1());
            ((SPSPOSSignatureScheme)this.params.getSignatureScheme()).updateOneTimeKey(this.params.getKeyPair2());
        }
    }

    @Test
    public void testSignatureAndVerifyWithFixedOTKeys() {
        SPSPOSSignatureScheme scheme = (SPSPOSSignatureScheme)this.params.getSignatureScheme();
        Zp.ZpElement fixedSecretKey = ((AKOT15SharedPublicParameters)this.params.getPublicParameters()).getZp().getUniformlyRandomElement();
        GroupElement fixedPublicKey = ((AKOT15SharedPublicParameters)this.params.getPublicParameters()).getG1GroupGenerator().pow((Zn.ZnElement)fixedSecretKey).compute();
        SPSPOSSignature sigma = scheme.sign(this.params.getMessage1(), this.params.getKeyPair1().getSigningKey(), fixedSecretKey);
        Assert.assertTrue((boolean)scheme.verify(this.params.getMessage1(), (Signature)sigma, this.params.getKeyPair1().getVerificationKey(), fixedPublicKey));
    }

    @Override
    public void testNegativeSignatureAndVerify() {
        for (int i = 0; i < testIterations; ++i) {
            SignatureSchemeTester.testSignatureSchemeSignAndVerify(this.params.getSignatureScheme(), this.params.getMessage1(), this.params.getKeyPair1().getVerificationKey(), this.params.getKeyPair1().getSigningKey());
            ((SPSPOSSignatureScheme)this.params.getSignatureScheme()).updateOneTimeKey(this.params.getKeyPair1());
            ((SPSPOSSignatureScheme)this.params.getSignatureScheme()).updateOneTimeKey(this.params.getKeyPair2());
        }
    }

    @Test
    public void testNegativeExpiredOTKeySignatureAndVerify() {
        for (int i = 0; i < testIterations; ++i) {
            SignatureSchemeTester.testSignatureSchemeSignAndVerify(this.params.getSignatureScheme(), this.params.getMessage1(), this.params.getKeyPair1().getVerificationKey(), this.params.getKeyPair1().getSigningKey());
            SignatureSchemeTester.testNegativeWrongKeysSignatureSchemeSignAndVerify(this.params.getSignatureScheme(), this.params.getMessage1(), this.params.getKeyPair1().getVerificationKey(), this.params.getKeyPair1().getSigningKey(), this.params.getKeyPair2().getVerificationKey(), this.params.getKeyPair2().getSigningKey());
        }
    }

    @Override
    public void testPublicParameterRepresentation() {
        AKOT15SharedPublicParameters ppTest = new AKOT15SharedPublicParameters(this.params.getPublicParameters().getRepresentation());
        Assert.assertEquals((Object)this.params.getPublicParameters(), (Object)ppTest);
    }
}

