/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.tc;

import org.cryptimeleon.craco.commitment.CommitmentKey;
import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.sps.CommitmentSchemeParams;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.akot15.tc.TCAKOT15CommitmentScheme;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15CommitmentKey;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class TCAKOT15CommitmentSchemeTestParameterGenerator {
    public static CommitmentSchemeParams generateParameters(int securityParameter, int messageLength) {
        AKOT15SharedPublicParameters pp = AKOT15SharedPublicParametersGen.generateParameters((int)securityParameter, (int)messageLength, (boolean)true);
        TCAKOT15CommitmentScheme scheme = new TCAKOT15CommitmentScheme(pp);
        TCGAKOT15CommitmentKey commitmentKey = scheme.generateKey();
        GroupElementPlainText[] messages = new GroupElementPlainText[messageLength];
        Zp zp = pp.getZp();
        for (int i = 0; i < messageLength; ++i) {
            messages[i] = new GroupElementPlainText(pp.getG2GroupGenerator().pow((Zn.ZnElement)zp.getUniformlyRandomElement()));
        }
        GroupElementPlainText[] wrongMessages = new GroupElementPlainText[messageLength];
        for (int i = 0; i < messageLength; ++i) {
            do {
                wrongMessages[i] = new GroupElementPlainText(pp.getG2GroupGenerator().pow((Zn.ZnElement)zp.getUniformlyRandomElement()));
            } while (messages[i].equals((Object)wrongMessages[i]));
        }
        return new CommitmentSchemeParams((PublicParameters)pp, (PlainText)new MessageBlock((PlainText[])messages), (PlainText)new MessageBlock((PlainText[])wrongMessages), (CommitmentScheme)scheme, (CommitmentKey)commitmentKey);
    }
}

