/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.tc;

import org.cryptimeleon.craco.commitment.CommitmentPair;
import org.cryptimeleon.craco.commitment.CommitmentSchemeTester;
import org.cryptimeleon.craco.sig.sps.CommitmentSchemeParams;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.tc.TCAKOT15CommitmentSchemeTestParameterGenerator;
import org.cryptimeleon.craco.sig.sps.akot15.tc.TCAKOT15OpenValue;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15Commitment;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.Group;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TCAKOT15CommitmentSchemeTester {
    private final int SECURITY_PARAMETER = 128;
    private final int MESSAGE_LENGTH = 32;
    CommitmentSchemeParams params;

    @Before
    public void generateParameters() {
        this.params = TCAKOT15CommitmentSchemeTestParameterGenerator.generateParameters(128, 32);
    }

    @Test
    public void testCommitAndVerify() {
        CommitmentSchemeTester.testCommitmentSchemeVerify(this.params.getScheme(), this.params.getPlainText());
    }

    @Test
    public void testCommitmentSchemeRepresentationText() {
        AKOT15SharedPublicParameters pp = (AKOT15SharedPublicParameters)this.params.getPublicParameters();
        CommitmentPair comPair = this.params.getScheme().commit(this.params.getPlainText());
        Representation comPairRepr = comPair.getRepresentation();
        ObjectRepresentation objRepr = (ObjectRepresentation)comPairRepr;
        Group tcgG2 = ((TCGAKOT15Commitment)comPair.getCommitment()).getGroup2ElementGu().getStructure();
        Group tcG1 = ((TCAKOT15OpenValue)comPair.getOpenValue()).group1ElementGamma.getStructure();
        Group tcG2 = ((TCAKOT15OpenValue)comPair.getOpenValue()).spsPosSignatures[0].getGroup2ElementR().getStructure();
        TCGAKOT15Commitment com = new TCGAKOT15Commitment(tcgG2, objRepr.get("com"));
        TCAKOT15OpenValue open = new TCAKOT15OpenValue(tcG1, tcG2, objRepr.get("open"));
        Assert.assertEquals((Object)comPair.getOpenValue(), (Object)open);
        Assert.assertEquals((Object)comPair.getCommitment(), (Object)com);
    }

    @Test
    public void testMapToPlaintext() {
        CommitmentSchemeTester.testCommitmentSchemeMapToPlaintext(this.params.getScheme());
    }
}

