/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.tcgamma;

import org.cryptimeleon.craco.commitment.CommitmentKey;
import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.sig.sps.CommitmentSchemeParams;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15CommitmentScheme;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class TCGAKOT15CommitmentSchemeTestParameterGenerator {
    public static CommitmentSchemeParams generateParameters(int securityParameter, int messageLength) {
        AKOT15SharedPublicParameters pp = AKOT15SharedPublicParametersGen.generateParameters((int)securityParameter, (int)messageLength, (boolean)true);
        TCGAKOT15CommitmentScheme scheme = new TCGAKOT15CommitmentScheme(pp);
        RingElementPlainText[] messages = new RingElementPlainText[messageLength];
        Zp zp = pp.getZp();
        for (int i = 0; i < messageLength; ++i) {
            messages[i] = new RingElementPlainText((RingElement)zp.getUniformlyRandomElement());
        }
        RingElementPlainText[] wrongMessages = new RingElementPlainText[messageLength];
        for (int i = 0; i < messageLength; ++i) {
            do {
                wrongMessages[i] = new RingElementPlainText((RingElement)zp.getUniformlyRandomElement());
            } while (messages[i].equals((Object)wrongMessages[i]));
        }
        return new CommitmentSchemeParams((PublicParameters)pp, (PlainText)new MessageBlock((PlainText[])messages), (PlainText)new MessageBlock((PlainText[])wrongMessages), (CommitmentScheme)scheme, (CommitmentKey)scheme.getCommitmentKey());
    }
}

