/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.tcgamma;

import org.cryptimeleon.craco.commitment.CommitmentPair;
import org.cryptimeleon.craco.commitment.CommitmentSchemeTester;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.sig.sps.CommitmentSchemeParams;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15CommitmentSchemeTestParameterGenerator;
import org.junit.Before;
import org.junit.Test;

public class TCGAKOT15CommitmentSchemeTests {
    private final int SECURITY_PARAMETER = 128;
    private final int MESSAGE_LENGTH = 1;
    CommitmentSchemeParams params;

    @Before
    public void generateParameters() {
        this.params = TCGAKOT15CommitmentSchemeTestParameterGenerator.generateParameters(128, 1);
    }

    @Test
    public void testCommitAndVerify() {
        CommitmentSchemeTester.testCommitmentSchemeVerify(this.params.getScheme(), this.params.getPlainText());
    }

    @Test
    public void testCommitAndVerifyWithGroupElementMessage() {
        GroupElementPlainText[] gePlainText = (GroupElementPlainText[])((MessageBlock)this.params.getPlainText()).stream().map(x -> new GroupElementPlainText(((AKOT15SharedPublicParameters)this.params.getPublicParameters()).getG1GroupGenerator().pow(((RingElementPlainText)x).getRingElement()).compute())).toArray(GroupElementPlainText[]::new);
        MessageBlock groupElementPlainText = new MessageBlock((PlainText[])gePlainText);
        CommitmentPair com = this.params.getScheme().commit(this.params.getPlainText());
        this.params.getScheme().verify(com.getCommitment(), com.getOpenValue(), (PlainText)groupElementPlainText);
    }

    @Test
    public void testNegativeWrongCommitAndVerify() {
        CommitmentSchemeTester.testCommitmentSchemeVerifyWithWrongMessages(this.params.getScheme(), this.params.getPlainText(), this.params.getWrongPlainText());
    }

    @Test
    public void testMapToPlaintext() {
        CommitmentSchemeTester.testCommitmentSchemeMapToPlaintext(this.params.getScheme());
    }
}

