/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.xsig;

import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGSignatureScheme;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGSigningKey;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGVerificationKey;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class SPSXSIGSignatureSchemeTestParamGenerator {
    public static SignatureSchemeParams generateParameters(int securityParameter, int numberOfMessageBlocks) {
        SignatureKeyPair wrongKeyPair;
        SPSXSIGPublicParameters pp = SPSXSIGPublicParametersGen.generatePublicParameters((int)securityParameter, (int)numberOfMessageBlocks, (boolean)true);
        SPSXSIGSignatureScheme scheme = new SPSXSIGSignatureScheme(pp);
        SignatureKeyPair keyPair = scheme.generateKeyPair(numberOfMessageBlocks);
        while (((SPSXSIGVerificationKey)(wrongKeyPair = scheme.generateKeyPair(numberOfMessageBlocks)).getVerificationKey()).equals((Object)keyPair.getVerificationKey()) || ((SPSXSIGSigningKey)wrongKeyPair.getSigningKey()).equals((Object)keyPair.getSigningKey())) {
        }
        MessageBlock[] messageTriplets = new MessageBlock[numberOfMessageBlocks];
        for (int i = 0; i < messageTriplets.length; ++i) {
            Zp.ZpElement mi = pp.getZp().getUniformlyRandomElement();
            GroupElementPlainText message1 = new GroupElementPlainText(pp.getGroup2ElementF1().pow((Zn.ZnElement)mi).compute());
            GroupElementPlainText message2 = new GroupElementPlainText(pp.getGroup2ElementF2().pow((Zn.ZnElement)mi).compute());
            GroupElementPlainText message3 = new GroupElementPlainText(pp.getGroup2ElementsU()[i].pow((Zn.ZnElement)mi).compute());
            messageTriplets[i] = new MessageBlock(new PlainText[]{message1, message2, message3});
        }
        MessageBlock[] wrongMessageTriplets = new MessageBlock[numberOfMessageBlocks];
        for (int i = 0; i < wrongMessageTriplets.length; ++i) {
            do {
                Zp.ZpElement mi = pp.getZp().getUniformlyRandomElement();
                GroupElementPlainText message1 = new GroupElementPlainText(pp.getGroup2ElementF1().pow((Zn.ZnElement)mi).compute());
                GroupElementPlainText message2 = new GroupElementPlainText(pp.getGroup2ElementF2().pow((Zn.ZnElement)mi).compute());
                GroupElementPlainText message3 = new GroupElementPlainText(pp.getGroup2ElementsU()[i].pow((Zn.ZnElement)mi).compute());
                wrongMessageTriplets[i] = new MessageBlock(new PlainText[]{message1, message2, message3});
            } while (wrongMessageTriplets[i].equals((Object)messageTriplets[i]));
        }
        return new SignatureSchemeParams((SignatureScheme)scheme, (PublicParameters)pp, (PlainText)new MessageBlock((PlainText[])messageTriplets), (PlainText)new MessageBlock((PlainText[])wrongMessageTriplets), (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)keyPair, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)wrongKeyPair);
    }
}

