/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.groth15;

import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SignatureSchemeTester;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15PublicParameters;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15PublicParametersGen;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15SignatureScheme;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15SignatureSchemeTestParamGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SPSGroth15SignatureSchemeTest {
    static long timerStart = 0L;
    static int testIterations = 1;
    private final int NUM_MESSAGES = 2;
    private final int SECURITY_PARAMETER = 128;
    private SPSGroth15SignatureScheme scheme;
    private SignatureKeyPair<? extends VerificationKey, ? extends SigningKey> keyPair;
    private SignatureKeyPair<? extends VerificationKey, ? extends SigningKey> wrongKeyPair;
    private SPSGroth15PublicParameters pp;
    private MessageBlock messageBlock;
    private MessageBlock wrongMessageBlock;

    protected static void measureTime(String str) {
        if (timerStart == 0L) {
            timerStart = System.currentTimeMillis();
        } else {
            long end = System.currentTimeMillis();
            System.out.println(str + ": " + (end - timerStart) / 1000L + "s, " + (end - timerStart) % 1000L + "ms");
            timerStart = 0L;
        }
    }

    @Before
    public void setUp() throws Exception {
        for (SPSGroth15PublicParametersGen.Groth15Type type : SPSGroth15PublicParametersGen.Groth15Type.values()) {
            for (int i = 0; i < 1; ++i) {
                SignatureSchemeParams params = SPSGroth15SignatureSchemeTestParamGenerator.generateParams(128, type, 2);
                this.scheme = (SPSGroth15SignatureScheme)params.getSignatureScheme();
                this.keyPair = params.getKeyPair1();
                this.wrongKeyPair = params.getKeyPair2();
                this.pp = (SPSGroth15PublicParameters)params.getPublicParameters();
                this.messageBlock = (MessageBlock)params.getMessage1();
                this.wrongMessageBlock = (MessageBlock)params.getMessage2();
            }
        }
    }

    @Test
    public void testSPSGroth15SignatureSchemeSignAndVerify() {
        for (int i = 0; i < testIterations; ++i) {
            SignatureSchemeTester.testSignatureSchemeSignAndVerify((SignatureScheme)this.scheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
        }
    }

    @Test
    public void testSPSGroth15SignatureSchemeRepresentationText() {
        SignatureSchemeTester.testRepresentationSignatureScheme((SignatureScheme)this.scheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
        SPSGroth15PublicParameters ppTest = new SPSGroth15PublicParameters(this.pp.getRepresentation());
        Assert.assertEquals((Object)this.pp, (Object)ppTest);
    }

    @Test
    public void testMapToPlaintext() {
        SignatureSchemeTester.testMapToPlaintext((SignatureScheme)this.scheme, this.keyPair.getVerificationKey());
    }

    @Test
    public void testMapToPlaintextContract() {
        SignatureSchemeTester.testMapToPlainTextContract((SignatureScheme)this.scheme, this.keyPair);
    }
}

