/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamUtil {
    private StreamUtil() {
    }

    public static void copyAsync(final InputStream readFrom, final OutputStream writeTo) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] data = new byte[8];
                    int length = readFrom.read(data);
                    while (length != -1) {
                        writeTo.write(data, 0, length);
                        length = readFrom.read(data);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        writeTo.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        t.start();
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        int read = 0;
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        StreamUtil.copy(in, out, 1024);
    }
}

