/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.sym.streaming.aes;

import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.CipherOutputStream;

abstract class SymmetricOutputstream
extends OutputStream {
    int byteOffset = 0;
    final int ivLengthInBytes;
    protected CipherOutputStream decryptedOut = null;
    protected OutputStream out;

    public SymmetricOutputstream(OutputStream out, int initialVectorLength) {
        this.out = out;
        this.ivLengthInBytes = initialVectorLength / 8;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.byteOffset < this.ivLengthInBytes) {
            this.setIV(this.byteOffset, (byte)b);
            if (this.byteOffset == this.ivLengthInBytes - 1) {
                this.setupOutputStream();
            }
            ++this.byteOffset;
        } else {
            this.decryptedOut.write(b);
        }
    }

    protected abstract void setupOutputStream();

    protected abstract void setIV(int var1, byte var2);

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.byteOffset < this.ivLengthInBytes) {
            for (int i = off; i < off + len; ++i) {
                this.write(b[i]);
            }
        } else {
            this.decryptedOut.write(b, off, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void flush() throws IOException {
        if (this.decryptedOut != null) {
            this.decryptedOut.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.decryptedOut != null) {
            this.decryptedOut.close();
        }
        this.out.close();
    }
}

