/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.kem;

import java.util.Arrays;
import java.util.Objects;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.enc.SymmetricKey;
import org.cryptimeleon.craco.kem.KeyDerivationFunction;
import org.cryptimeleon.craco.kem.KeyMaterial;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.impl.SHA256HashFunction;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;

public class HashBasedKeyDerivationFunction
implements KeyDerivationFunction<SymmetricKey> {
    @Represented
    private HashFunction hashFunction;

    public HashBasedKeyDerivationFunction(HashFunction hashFunction) {
        this.hashFunction = hashFunction;
    }

    public HashBasedKeyDerivationFunction() {
        this((HashFunction)new SHA256HashFunction());
    }

    public HashBasedKeyDerivationFunction(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    @Override
    public SymmetricKey deriveKey(KeyMaterial material) {
        byte[] hashedPlainText = this.hashFunction.hash((UniqueByteRepresentable)material);
        return new ByteArrayImplementation(Arrays.copyOfRange(hashedPlainText, 0, 16));
    }

    public int bitSize() {
        return this.hashFunction.getOutputLength();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hashFunction == null ? 0 : this.hashFunction.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashBasedKeyDerivationFunction other = (HashBasedKeyDerivationFunction)obj;
        return Objects.equals(this.hashFunction, other.hashFunction);
    }
}

