/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma;

import java.math.BigInteger;
import org.cryptimeleon.craco.protocols.arguments.sigma.Challenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.ChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallengeSpace;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class ZnChallenge
implements Challenge {
    protected Zn.ZnElement challenge;

    public ZnChallenge(Zn.ZnElement challenge) {
        this.challenge = challenge;
    }

    public BigInteger getChallenge() {
        return this.challenge.asInteger();
    }

    public Representation getRepresentation() {
        return this.challenge.getRepresentation();
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator byteAccumulator) {
        byteAccumulator.append((UniqueByteRepresentable)this.challenge);
        return byteAccumulator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZnChallenge that = (ZnChallenge)o;
        return this.challenge.equals((Object)that.challenge);
    }

    public int hashCode() {
        return this.challenge.hashCode();
    }

    @Override
    public ChallengeSpace getChallengeSpace() {
        return new ZnChallengeSpace(this.challenge.getStructure());
    }
}

