/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.partial;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Challenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.ChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocolTranscript;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.cartesian.Vector;

public class OrProof
implements SigmaProtocol {
    public final SigmaProtocol protocol0;
    public final SigmaProtocol protocol1;

    public OrProof(SigmaProtocol protocol0, SigmaProtocol protocol1) {
        this.protocol0 = protocol0;
        this.protocol1 = protocol1;
    }

    private <T> T getSimulated(SecretInput secretInput, T protocol0, T protocol1) {
        return ((OrProofSecretInput)secretInput).isForProtocol1 ? protocol0 : protocol1;
    }

    private <T> T getHonest(SecretInput secretInput, T protocol0, T protocol1) {
        return ((OrProofSecretInput)secretInput).isForProtocol1 ? protocol1 : protocol0;
    }

    private <T> T getHonest(SecretInput secretInput, Vector<T> vector) {
        return (T)(((OrProofSecretInput)secretInput).isForProtocol1 ? vector.get(1) : vector.get(0));
    }

    private <T> T getSimulated(SecretInput secretInput, Vector<T> vector) {
        return (T)(((OrProofSecretInput)secretInput).isForProtocol1 ? vector.get(0) : vector.get(1));
    }

    private <T> T getProtocol0(SecretInput secretInput, T honest, T simulated) {
        return ((OrProofSecretInput)secretInput).isForProtocol1 ? simulated : honest;
    }

    private <T> T getProtocol1(SecretInput secretInput, T honest, T simulated) {
        return ((OrProofSecretInput)secretInput).isForProtocol1 ? honest : simulated;
    }

    private <T, Y extends Vector<? extends T>> Y getVector(SecretInput secretInput, T honest, T simulated, Function<List<? extends T>, Y> constructor) {
        return (Y)(((OrProofSecretInput)secretInput).isForProtocol1 ? (Vector)constructor.apply(Arrays.asList(simulated, honest)) : (Vector)constructor.apply(Arrays.asList(honest, simulated)));
    }

    @Override
    public AnnouncementSecret generateAnnouncementSecret(CommonInput commonInput, SecretInput secretInput) {
        SigmaProtocol simulationProtocol = this.getSimulated(secretInput, this.protocol0, this.protocol1);
        SigmaProtocol honestProtocol = this.getHonest(secretInput, this.protocol0, this.protocol1);
        CommonInput simulationProtocolCommonInput = this.getSimulated(secretInput, (CommonInput.CommonInputVector)commonInput);
        CommonInput honestProtocolCommonInput = this.getHonest(secretInput, (CommonInput.CommonInputVector)commonInput);
        SigmaProtocolTranscript simulatedTranscript = simulationProtocol.generateSimulatedTranscript(simulationProtocolCommonInput, simulationProtocol.generateChallenge(simulationProtocolCommonInput));
        AnnouncementSecret announcementSecret = honestProtocol.generateAnnouncementSecret(honestProtocolCommonInput, ((OrProofSecretInput)secretInput).secretInput);
        Announcement announcement = honestProtocol.generateAnnouncement(honestProtocolCommonInput, ((OrProofSecretInput)secretInput).secretInput, announcementSecret);
        return new OrProofAnnouncementSecret(announcementSecret, announcement, simulatedTranscript);
    }

    @Override
    public Announcement generateAnnouncement(CommonInput commonInput, SecretInput secretInput, AnnouncementSecret announcementSecret) {
        Announcement simulatedAnnouncement = ((OrProofAnnouncementSecret)announcementSecret).simulatedTranscript.getAnnouncement();
        Announcement honestAnnouncement = ((OrProofAnnouncementSecret)announcementSecret).announcement;
        return this.getVector(secretInput, honestAnnouncement, simulatedAnnouncement, Announcement.AnnouncementVector::new);
    }

    @Override
    public ChallengeSpace getChallengeSpace(CommonInput commonInput) {
        ChallengeSpace challengeSpace = this.protocol0.getChallengeSpace((CommonInput)((CommonInput.CommonInputVector)commonInput).get(0));
        if (!this.protocol1.getChallengeSpace((CommonInput)((CommonInput.CommonInputVector)commonInput).get(1)).equals(challengeSpace)) {
            throw new IllegalStateException("Challenge spaces of subprotocols inconsistent.");
        }
        return challengeSpace;
    }

    @Override
    public Response generateResponse(CommonInput commonInput, SecretInput secretInput, Announcement announcement, AnnouncementSecret announcementSecret, Challenge challenge) {
        ChallengeSpace challengeSpace = this.getChallengeSpace(commonInput);
        Challenge honestChallenge = challengeSpace.subtract(challenge, ((OrProofAnnouncementSecret)announcementSecret).simulatedTranscript.getChallenge());
        Response honestResponse = this.getHonest(secretInput, this.protocol0, this.protocol1).generateResponse(this.getHonest(secretInput, (CommonInput.CommonInputVector)commonInput), ((OrProofSecretInput)secretInput).secretInput, ((OrProofAnnouncementSecret)announcementSecret).announcement, ((OrProofAnnouncementSecret)announcementSecret).announcementSecret, honestChallenge);
        return new OrProofResponse(this.getVector(secretInput, honestResponse, ((OrProofAnnouncementSecret)announcementSecret).simulatedTranscript.getResponse(), Response.ResponseVector::new), this.getProtocol0(secretInput, honestChallenge, ((OrProofAnnouncementSecret)announcementSecret).simulatedTranscript.getChallenge()));
    }

    @Override
    public BooleanExpression checkTranscriptAsExpression(CommonInput commonInput, Announcement announcement, Challenge challenge, Response response) {
        Challenge challenge0 = ((OrProofResponse)response).challenge0;
        Challenge challenge1 = this.getChallengeSpace(commonInput).subtract(challenge, challenge0);
        return this.protocol0.checkTranscriptAsExpression((CommonInput)((CommonInput.CommonInputVector)commonInput).get(0), (Announcement)((Announcement.AnnouncementVector)announcement).get(0), challenge0, ((OrProofResponse)response).response0).and(this.protocol1.checkTranscriptAsExpression((CommonInput)((CommonInput.CommonInputVector)commonInput).get(1), (Announcement)((Announcement.AnnouncementVector)announcement).get(1), challenge1, ((OrProofResponse)response).response1));
    }

    @Override
    public SigmaProtocolTranscript generateSimulatedTranscript(CommonInput commonInput, Challenge challenge) {
        ChallengeSpace challengeSpace = this.getChallengeSpace(commonInput);
        Challenge challenge0 = challengeSpace.generateRandomChallenge();
        Challenge challenge1 = challengeSpace.subtract(challenge, challenge0);
        SigmaProtocolTranscript transcript0 = this.protocol0.generateSimulatedTranscript((CommonInput)((CommonInput.CommonInputVector)commonInput).get(0), challenge0);
        SigmaProtocolTranscript transcript1 = this.protocol1.generateSimulatedTranscript((CommonInput)((CommonInput.CommonInputVector)commonInput).get(1), challenge1);
        return new SigmaProtocolTranscript(new Announcement.AnnouncementVector(transcript0.getAnnouncement(), transcript1.getAnnouncement()), challenge, new OrProofResponse(transcript0.getResponse(), transcript1.getResponse(), challenge0));
    }

    @Override
    public Announcement restoreAnnouncement(CommonInput commonInput, Representation repr) {
        return (Announcement)Vector.of((Object[])new SigmaProtocol[]{this.protocol0, this.protocol1}).map((i, protocol) -> protocol.restoreAnnouncement((CommonInput)((CommonInput.CommonInputVector)commonInput).get((int)i), repr.list().get(i.intValue())), Announcement.AnnouncementVector::new);
    }

    @Override
    public Response restoreResponse(CommonInput commonInput, Announcement announcement, Challenge challenge, Representation repr) {
        ChallengeSpace challengeSpace = this.getChallengeSpace(commonInput);
        Challenge challenge0 = challengeSpace.restoreChallenge(repr.list().get(2));
        Challenge challenge1 = challengeSpace.subtract(challenge, challenge0);
        Response.ResponseVector responses = (Response.ResponseVector)Vector.of((Object[])new SigmaProtocol[]{this.protocol0, this.protocol1}).map((i, protocol) -> protocol.restoreResponse((CommonInput)((CommonInput.CommonInputVector)commonInput).get((int)i), (Announcement)((Announcement.AnnouncementVector)announcement).get((int)i), i == 0 ? challenge0 : challenge1, repr.list().get(i.intValue())), Response.ResponseVector::new);
        return new OrProofResponse(responses, challenge0);
    }

    @Override
    public void debugProof(CommonInput commonInput, SecretInput secretInput) {
        try {
            if (((OrProofSecretInput)secretInput).isForProtocol1) {
                this.protocol1.debugProof((CommonInput)((CommonInput.CommonInputVector)commonInput).get(1), ((OrProofSecretInput)secretInput).secretInput);
            } else {
                this.protocol0.debugProof((CommonInput)((CommonInput.CommonInputVector)commonInput).get(0), ((OrProofSecretInput)secretInput).secretInput);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("OR proof " + (((OrProofSecretInput)secretInput).isForProtocol1 ? "right" : "left") + " child threw error (other child wasn't asked)");
        }
    }

    private static class OrProofAnnouncementSecret
    implements AnnouncementSecret {
        public final AnnouncementSecret announcementSecret;
        public final Announcement announcement;
        public final SigmaProtocolTranscript simulatedTranscript;

        public OrProofAnnouncementSecret(AnnouncementSecret announcementSecret, Announcement announcement, SigmaProtocolTranscript simulatedTranscript) {
            this.announcementSecret = announcementSecret;
            this.announcement = announcement;
            this.simulatedTranscript = simulatedTranscript;
        }
    }

    protected static class OrProofResponse
    implements Response {
        public final Response response0;
        public final Response response1;
        public final Challenge challenge0;

        public OrProofResponse(Response response0, Response response1, Challenge challenge0) {
            this.response0 = response0;
            this.response1 = response1;
            this.challenge0 = challenge0;
        }

        public OrProofResponse(Response.ResponseVector responses, Challenge challenge0) {
            this((Response)responses.get(0), (Response)responses.get(1), challenge0);
        }

        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            accumulator.escapeAndSeparate((UniqueByteRepresentable)this.response0);
            accumulator.escapeAndSeparate((UniqueByteRepresentable)this.response1);
            accumulator.escapeAndSeparate((UniqueByteRepresentable)this.challenge0);
            return accumulator;
        }

        public Representation getRepresentation() {
            return new ListRepresentation(new Representation[]{this.response0.getRepresentation(), this.response1.getRepresentation(), this.challenge0.getRepresentation()});
        }
    }

    public static class OrProofSecretInput
    implements SecretInput {
        public final SecretInput secretInput;
        public final boolean isForProtocol1;

        public OrProofSecretInput(SecretInput secretInput, boolean isForProtocol1) {
            this.secretInput = secretInput;
            this.isForProtocol1 = isForProtocol1;
        }
    }
}

