/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.partial;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Challenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocolTranscript;
import org.cryptimeleon.craco.protocols.arguments.sigma.partial.AndProof;
import org.cryptimeleon.craco.protocols.arguments.sigma.partial.OrProof;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SendFirstValue;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representation;

public abstract class ProofOfPartialKnowledge
implements SigmaProtocol {
    protected abstract ProtocolTree provideProtocolTree(CommonInput var1, SendFirstValue var2);

    protected abstract ProverSpec provideProverSpec(CommonInput var1, SecretInput var2, ProverSpecBuilder var3);

    protected abstract SendFirstValue restoreSendFirstValue(CommonInput var1, Representation var2);

    protected abstract SendFirstValue simulateSendFirstValue(CommonInput var1);

    protected abstract BooleanExpression provideAdditionalCheck(CommonInput var1, SendFirstValue var2);

    protected final ProtocolTree leaf(String name, SigmaProtocol protocol, CommonInput commonInput) {
        return new LeafNode(protocol, name, commonInput);
    }

    protected final ProtocolTree and(ProtocolTree protocol1, ProtocolTree protocol2) {
        return new AndNode(protocol1, protocol2);
    }

    protected final ProtocolTree or(ProtocolTree protocol1, ProtocolTree protocol2) {
        return new OrNode(protocol1, protocol2);
    }

    @Override
    public AnnouncementSecret generateAnnouncementSecret(CommonInput commonInput, SecretInput secretInput) {
        ProverSpec proverSpec = this.provideProverSpec(commonInput, secretInput, new ProverSpecBuilder());
        ProtocolTree tree = this.provideProtocolTree(commonInput, proverSpec.sendFirstValue);
        CommonInput protocolCommonInput = tree.getCommonInput();
        SecretInput protocolSecretInput = tree.getSecretInput(proverSpec.secretInputs);
        AnnouncementSecret protocolAnnouncementSecret = tree.protocol.generateAnnouncementSecret(protocolCommonInput, protocolSecretInput);
        Announcement protocolAnnouncement = tree.protocol.generateAnnouncement(protocolCommonInput, protocolSecretInput, protocolAnnouncementSecret);
        return new PartialKnowledgeAnnouncementSecret(protocolAnnouncementSecret, proverSpec, tree, protocolCommonInput, protocolSecretInput, protocolAnnouncement);
    }

    @Override
    public Announcement generateAnnouncement(CommonInput commonInput, SecretInput secretInput, AnnouncementSecret announcementSecret) {
        return new PartialKnowledgeAnnouncement(((PartialKnowledgeAnnouncementSecret)announcementSecret).proverSpec.sendFirstValue, ((PartialKnowledgeAnnouncementSecret)announcementSecret).protocolAnnouncement, ((PartialKnowledgeAnnouncementSecret)announcementSecret).protocolTree);
    }

    @Override
    public Response generateResponse(CommonInput commonInput, SecretInput secretInput, Announcement announcement, AnnouncementSecret announcementSecret, Challenge challenge) {
        PartialKnowledgeAnnouncementSecret announcementSecret1 = (PartialKnowledgeAnnouncementSecret)announcementSecret;
        return announcementSecret1.protocolTree.protocol.generateResponse(announcementSecret1.protocolCommonInput, announcementSecret1.protocolSecretInput, announcementSecret1.protocolAnnouncement, announcementSecret1.protocolAnnouncementSecret, challenge);
    }

    @Override
    public BooleanExpression checkTranscriptAsExpression(CommonInput commonInput, Announcement announcement, Challenge challenge, Response response) {
        SendFirstValue sendFirstValue = ((PartialKnowledgeAnnouncement)announcement).sendFirstValue;
        ProtocolTree tree = ((PartialKnowledgeAnnouncement)announcement).protocolTree;
        return this.provideAdditionalCheck(commonInput, sendFirstValue).and(tree.protocol.checkTranscriptAsExpression(tree.getCommonInput(), ((PartialKnowledgeAnnouncement)announcement).protocolAnnouncement, challenge, response));
    }

    @Override
    public SigmaProtocolTranscript generateSimulatedTranscript(CommonInput commonInput, Challenge challenge) {
        SendFirstValue sendFirstValue = this.simulateSendFirstValue(commonInput);
        ProtocolTree tree = this.provideProtocolTree(commonInput, sendFirstValue);
        SigmaProtocolTranscript protocolTranscript = tree.protocol.generateSimulatedTranscript(tree.getCommonInput(), challenge);
        return new SigmaProtocolTranscript(new PartialKnowledgeAnnouncement(sendFirstValue, protocolTranscript.getAnnouncement(), tree), challenge, protocolTranscript.getResponse());
    }

    @Override
    public Announcement restoreAnnouncement(CommonInput commonInput, Representation repr) {
        SendFirstValue sendFirstValue = this.restoreSendFirstValue(commonInput, repr.list().get(0));
        ProtocolTree tree = this.provideProtocolTree(commonInput, sendFirstValue);
        return new PartialKnowledgeAnnouncement(sendFirstValue, tree.protocol.restoreAnnouncement(tree.getCommonInput(), repr.list().get(1)), tree);
    }

    @Override
    public Response restoreResponse(CommonInput commonInput, Announcement announcement, Challenge challenge, Representation repr) {
        return ((PartialKnowledgeAnnouncement)announcement).protocolTree.protocol.restoreResponse(((PartialKnowledgeAnnouncement)announcement).protocolTree.getCommonInput(), ((PartialKnowledgeAnnouncement)announcement).protocolAnnouncement, challenge, repr);
    }

    @Override
    public void debugProof(CommonInput commonInput, SecretInput secretInput) {
        ProverSpec proverSpec = this.provideProverSpec(commonInput, secretInput, new ProverSpecBuilder());
        ProtocolTree protocolTree = this.provideProtocolTree(commonInput, proverSpec.sendFirstValue);
        if (!this.provideAdditionalCheck(commonInput, proverSpec.sendFirstValue).evaluate().booleanValue()) {
            throw new RuntimeException("Error checking the validity of sendFirstValue in " + this.getClass().getName());
        }
        protocolTree.debugProof(proverSpec.secretInputs);
    }

    private static class PartialKnowledgeAnnouncement
    implements Announcement {
        public final SendFirstValue sendFirstValue;
        public final Announcement protocolAnnouncement;
        public final ProtocolTree protocolTree;

        private PartialKnowledgeAnnouncement(SendFirstValue sendFirstValue, Announcement protocolAnnouncement, ProtocolTree protocolTree) {
            this.sendFirstValue = sendFirstValue;
            this.protocolAnnouncement = protocolAnnouncement;
            this.protocolTree = protocolTree;
        }

        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            accumulator.escapeAndSeparate((UniqueByteRepresentable)this.sendFirstValue);
            accumulator.append((UniqueByteRepresentable)this.protocolAnnouncement);
            return accumulator;
        }

        public Representation getRepresentation() {
            return new ListRepresentation(new Representation[]{this.sendFirstValue.getRepresentation(), this.protocolAnnouncement.getRepresentation()});
        }
    }

    private static class PartialKnowledgeAnnouncementSecret
    implements AnnouncementSecret {
        public final AnnouncementSecret protocolAnnouncementSecret;
        public final ProverSpec proverSpec;
        public final ProtocolTree protocolTree;
        public final CommonInput protocolCommonInput;
        public final SecretInput protocolSecretInput;
        public final Announcement protocolAnnouncement;

        public PartialKnowledgeAnnouncementSecret(AnnouncementSecret protocolAnnouncementSecret, ProverSpec proverSpec, ProtocolTree protocolTree, CommonInput protocolCommonInput, SecretInput protocolSecretInput, Announcement protocolAnnouncement) {
            this.protocolAnnouncementSecret = protocolAnnouncementSecret;
            this.proverSpec = proverSpec;
            this.protocolTree = protocolTree;
            this.protocolCommonInput = protocolCommonInput;
            this.protocolSecretInput = protocolSecretInput;
            this.protocolAnnouncement = protocolAnnouncement;
        }
    }

    public static class ProverSpecBuilder {
        private SendFirstValue sendFirstValue;
        private final Map<String, SecretInput> secretInputs = new HashMap<String, SecretInput>();
        private boolean isBuilt = false;

        private ProverSpecBuilder() {
        }

        public void setSendFirstValue(SendFirstValue sendFirstValue) {
            if (this.sendFirstValue != null) {
                throw new IllegalStateException("Cannot overwrite sendFirstValue");
            }
            this.sendFirstValue = sendFirstValue;
        }

        public void putSecretInput(String protocolName, SecretInput secretInput) {
            if (this.secretInputs.containsKey(protocolName)) {
                throw new IllegalArgumentException("Secret input for " + protocolName + " has already been set.");
            }
            this.secretInputs.put(protocolName, secretInput);
        }

        public ProverSpec build() {
            if (this.isBuilt) {
                throw new IllegalStateException("has already been built");
            }
            this.isBuilt = true;
            if (this.sendFirstValue == null) {
                throw new IllegalStateException("sendFirstValue is not set (use EmptySendFirstValue if you don't want any)");
            }
            return new ProverSpec(this.sendFirstValue, this.secretInputs::get);
        }
    }

    public static class ProverSpec {
        public final SendFirstValue sendFirstValue;
        public final Function<String, ? extends SecretInput> secretInputs;

        private ProverSpec(SendFirstValue sendFirstValue, Function<String, ? extends SecretInput> secretInputs) {
            this.sendFirstValue = sendFirstValue;
            this.secretInputs = secretInputs;
        }
    }

    private static class OrNode
    extends ProtocolTree {
        public final ProtocolTree lhs;
        public final ProtocolTree rhs;

        public OrNode(ProtocolTree lhs, ProtocolTree rhs) {
            super(new OrProof(lhs.protocol, rhs.protocol));
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        protected CommonInput getCommonInput() {
            return new CommonInput.CommonInputVector(this.lhs.getCommonInput(), this.rhs.getCommonInput());
        }

        @Override
        protected SecretInput getSecretInput(Function<String, ? extends SecretInput> secretInputsForLeafs) {
            SecretInput l = this.lhs.getSecretInput(secretInputsForLeafs);
            SecretInput r = this.rhs.getSecretInput(secretInputsForLeafs);
            if (l == null && r == null) {
                return null;
            }
            return l == null ? new OrProof.OrProofSecretInput(r, true) : new OrProof.OrProofSecretInput(l, false);
        }

        @Override
        public void debugProof(Function<String, ? extends SecretInput> secretInputs) {
            SecretInput l = this.lhs.getSecretInput(secretInputs);
            SecretInput r = this.rhs.getSecretInput(secretInputs);
            if (l == null && r == null) {
                throw new RuntimeException("No witness given for " + this);
            }
            if (l == null) {
                this.lhs.debugProof(secretInputs);
            }
            if (r == null) {
                this.rhs.debugProof(secretInputs);
            }
        }

        public String toString() {
            return "(" + this.lhs.toString() + " OR " + this.rhs.toString() + ")";
        }
    }

    private static class AndNode
    extends ProtocolTree {
        public final ProtocolTree lhs;
        public final ProtocolTree rhs;

        public AndNode(ProtocolTree lhs, ProtocolTree rhs) {
            super(new AndProof(lhs.protocol, rhs.protocol));
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        protected CommonInput getCommonInput() {
            return new CommonInput.CommonInputVector(this.lhs.getCommonInput(), this.rhs.getCommonInput());
        }

        @Override
        protected SecretInput getSecretInput(Function<String, ? extends SecretInput> secretInputsForLeafs) {
            SecretInput l = this.lhs.getSecretInput(secretInputsForLeafs);
            if (l == null) {
                return null;
            }
            SecretInput r = this.rhs.getSecretInput(secretInputsForLeafs);
            if (r == null) {
                return null;
            }
            return new SecretInput.SecretInputVector(l, r);
        }

        @Override
        public void debugProof(Function<String, ? extends SecretInput> secretInputs) {
            this.lhs.debugProof(secretInputs);
            this.rhs.debugProof(secretInputs);
        }

        public String toString() {
            return "(" + this.lhs.toString() + " AND " + this.rhs.toString() + ")";
        }
    }

    private static class LeafNode
    extends ProtocolTree {
        public final String name;
        protected final CommonInput commonInput;

        public LeafNode(SigmaProtocol protocol, String name, CommonInput commonInput) {
            super(protocol);
            this.name = name;
            this.commonInput = commonInput;
        }

        @Override
        protected CommonInput getCommonInput() {
            return this.commonInput;
        }

        @Override
        protected SecretInput getSecretInput(Function<String, ? extends SecretInput> secretInputsForLeafs) {
            return secretInputsForLeafs.apply(this.name);
        }

        @Override
        public void debugProof(Function<String, ? extends SecretInput> secretInputs) {
            SecretInput secretInput = secretInputs.apply(this.name);
            if (secretInput == null) {
                throw new RuntimeException("No witness for " + this.name + " subprotocol");
            }
            try {
                this.protocol.debugProof(this.commonInput, secretInput);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error in subprotocol " + this.name);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    protected static abstract class ProtocolTree {
        protected final SigmaProtocol protocol;

        public ProtocolTree(SigmaProtocol protocol) {
            this.protocol = protocol;
        }

        protected abstract CommonInput getCommonInput();

        protected abstract SecretInput getSecretInput(Function<String, ? extends SecretInput> var1);

        public abstract void debugProof(Function<String, ? extends SecretInput> var1);
    }
}

