/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ecdsa;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import java.util.Objects;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.ecdsa.ECDSASignature;
import org.cryptimeleon.craco.sig.ecdsa.ECDSASigningKey;
import org.cryptimeleon.craco.sig.ecdsa.ECDSAVerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StringRepresentation;

public class ECDSASignatureScheme
implements SignatureScheme {
    static final String ALGORITHM = "EC";
    static final String CURVE = "secp256r1";
    private static final String SIGNING_ALGORITHM = "SHA256withECDSA";
    private final java.security.Signature signer;

    public ECDSASignatureScheme() {
        try {
            this.signer = java.security.Signature.getInstance(SIGNING_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public SignatureKeyPair<ECDSAVerificationKey, ECDSASigningKey> generateKeyPair() {
        try {
            ECGenParameterSpec ecSpec = new ECGenParameterSpec(CURVE);
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM);
            keyGen.initialize(ecSpec);
            KeyPair keyPair = keyGen.generateKeyPair();
            return new SignatureKeyPair<ECDSAVerificationKey, ECDSASigningKey>(new ECDSAVerificationKey(keyPair.getPublic()), new ECDSASigningKey(keyPair.getPrivate()));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Signature sign(PlainText plainText, SigningKey secretKey) {
        ECDSASigningKey ecdsaSigningKey = (ECDSASigningKey)secretKey;
        try {
            this.signer.initSign(ecdsaSigningKey.getKey());
            this.signer.update(plainText.getUniqueByteRepresentation());
            return new ECDSASignature(this.signer.sign());
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Input secretKey must a valid EC secret key");
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey) {
        ECDSAVerificationKey ecdsaVerificationKey = (ECDSAVerificationKey)publicKey;
        ECDSASignature ecdsaSignature = (ECDSASignature)signature;
        try {
            this.signer.initVerify(ecdsaVerificationKey.getKey());
            this.signer.update(plainText.getUniqueByteRepresentation());
            return this.signer.verify(ecdsaSignature.bytes);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Input publicKey must a valid EC public key");
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PlainText restorePlainText(Representation repr) {
        return new MessageBlock(repr, ByteArrayImplementation::new);
    }

    @Override
    public Signature restoreSignature(Representation repr) {
        return new ECDSASignature(repr);
    }

    @Override
    public SigningKey restoreSigningKey(Representation repr) {
        return new ECDSASigningKey(repr);
    }

    @Override
    public VerificationKey restoreVerificationKey(Representation repr) {
        return new ECDSAVerificationKey(repr);
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, VerificationKey pk) {
        return new ByteArrayImplementation(bytes);
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, SigningKey sk) {
        return new ByteArrayImplementation(bytes);
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return Integer.MAX_VALUE;
    }

    public Representation getRepresentation() {
        return new StringRepresentation("");
    }

    public ECDSASignatureScheme(Representation repr) {
        this();
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(19817349853L);
    }
}

