/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ecdsa;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.StringRepresentation;

public class ECDSAVerificationKey
implements VerificationKey,
StandaloneRepresentable {
    private final PublicKey key;

    public ECDSAVerificationKey(PublicKey privateKey) {
        this.key = privateKey;
    }

    public ECDSAVerificationKey(Representation repr) {
        byte[] encodedKey = Base64.getDecoder().decode(((StringRepresentation)repr).get());
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encodedKey);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            this.key = keyFactory.generatePublic(pubKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    PublicKey getKey() {
        return this.key;
    }

    public Representation getRepresentation() {
        String encodedKey = Base64.getEncoder().encodeToString(this.key.getEncoded());
        return new StringRepresentation(encodedKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECDSAVerificationKey that = (ECDSAVerificationKey)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

