/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps;

import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.ps.PSExtendedVerificationKey;
import org.cryptimeleon.craco.sig.ps.PSPublicParameters;
import org.cryptimeleon.craco.sig.ps.PSSignatureScheme;
import org.cryptimeleon.craco.sig.ps.PSSigningKey;
import org.cryptimeleon.craco.sig.ps.PSVerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.cartesian.Vector;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;

public class PSExtendedSignatureScheme
extends PSSignatureScheme {
    public PSExtendedSignatureScheme(PSPublicParameters pp) {
        super(pp);
    }

    public PSExtendedSignatureScheme(Representation rep) {
        super(rep);
    }

    public SignatureKeyPair<PSExtendedVerificationKey, PSSigningKey> generateKeyPair(int numberOfMessages) {
        SignatureKeyPair<? extends PSVerificationKey, ? extends PSSigningKey> shortKey = super.generateKeyPair(numberOfMessages);
        GroupElement group1ElementG = this.getPp().getBilinearMap().getG1().getGenerator();
        GroupElementVector group1ElementsYi = group1ElementG.pow((Vector)shortKey.getSigningKey().getExponentsYi());
        PSVerificationKey shortVerificationKey = shortKey.getVerificationKey();
        PSExtendedVerificationKey extendedVerificationKey = new PSExtendedVerificationKey(group1ElementG, group1ElementsYi, shortVerificationKey.getGroup2ElementTildeG(), shortVerificationKey.getGroup2ElementTildeX(), shortVerificationKey.getGroup2ElementsTildeYi());
        return new SignatureKeyPair<PSExtendedVerificationKey, PSSigningKey>(extendedVerificationKey, shortKey.getSigningKey());
    }

    @Override
    public PSExtendedVerificationKey restoreVerificationKey(Representation repr) {
        BilinearMap bilinearMap = super.getPp().getBilinearMap();
        return new PSExtendedVerificationKey(bilinearMap.getG1(), bilinearMap.getG2(), repr);
    }
}

