/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps;

import java.util.Objects;
import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.ps.PSVerificationKey;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.hash.impl.ByteArrayAccumulator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;

public class PSExtendedVerificationKey
extends PSVerificationKey
implements VerificationKey,
UniqueByteRepresentable,
CommonInput {
    @UniqueByteRepresented
    @Represented(restorer="G1")
    private GroupElement group1ElementG;
    @UniqueByteRepresented
    @Represented(restorer="G1")
    private GroupElementVector group1ElementsYi;

    public PSExtendedVerificationKey(GroupElement group1Element, GroupElementVector group1ElementsYi, GroupElement group2ElementTildeG, GroupElement group2ElementTildeX, GroupElementVector group2ElementsTildeYi) {
        super(group2ElementTildeG, group2ElementTildeX, group2ElementsTildeYi);
        this.group1ElementG = group1Element;
        this.group1ElementsYi = group1ElementsYi;
    }

    private PSExtendedVerificationKey() {
    }

    public PSExtendedVerificationKey(Group groupG1, Group groupG2, Representation repr) {
        new ReprUtil((Object)this).register((RepresentationRestorer)groupG1, "G1").register((RepresentationRestorer)groupG2, "G2").deserialize(repr);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public GroupElement getGroup1ElementG() {
        return this.group1ElementG;
    }

    public GroupElementVector getGroup1ElementsYi() {
        return this.group1ElementsYi;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PSExtendedVerificationKey that = (PSExtendedVerificationKey)o;
        return Objects.equals(this.group1ElementG, that.group1ElementG) && Objects.equals(this.group1ElementsYi, that.group1ElementsYi);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.group1ElementG);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator byteAccumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)byteAccumulator, (Object)this);
    }

    public byte[] getUniqueByteRepresentation() {
        return this.updateAccumulator((ByteAccumulator)new ByteArrayAccumulator()).extractBytes();
    }
}

