/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps;

import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.math.structures.groups.Group;

public interface SPSMessageSpaceVerifier {
    default public void doMessageChecks(PlainText plainText, int expectedMessageLength, Group expectedGroup) throws IllegalArgumentException {
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("The scheme requires its messages to a MessageBlock");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        if (messageBlock.length() != expectedMessageLength) {
            throw new IllegalArgumentException(String.format("The scheme expected a message of length %d, but the size was: %d", expectedMessageLength, messageBlock.length()));
        }
        for (int i = 0; i < messageBlock.length(); ++i) {
            if (!(messageBlock.get(i) instanceof GroupElementPlainText)) {
                throw new IllegalArgumentException(String.format("The scheme expected its Messages to contain GroupElements, but element %d was of type: %s", i, ((PlainText)messageBlock.get(i)).getClass().toString()));
            }
            GroupElementPlainText group1ElementPT = (GroupElementPlainText)messageBlock.get(i);
            if (group1ElementPT.get().getStructure().equals(expectedGroup)) continue;
            throw new IllegalArgumentException(String.format("The scheme expected GroupElements in %s, but element %d was in: %s", expectedGroup.toString(), i, group1ElementPT.get().getStructure().toString()));
        }
    }
}

