/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.fsp2;

import java.util.Objects;
import org.cryptimeleon.craco.commitment.CommitmentPair;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.sps.akot15.tc.TCAKOT15OpenValue;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15Commitment;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15XSIGCommitment;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGSignature;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.Group;

public class SPSFSP2Signature
implements Signature {
    SPSXSIGSignature sigmaXSIG;
    CommitmentPair commitmentPairTC;

    public SPSFSP2Signature(SPSXSIGSignature sigmaXSIG, CommitmentPair commitmentPairTC) {
        this.sigmaXSIG = sigmaXSIG;
        this.commitmentPairTC = commitmentPairTC;
    }

    public SPSFSP2Signature(Group g1, Group g2, Representation repr) {
        ObjectRepresentation objRepr = (ObjectRepresentation)repr;
        this.sigmaXSIG = new SPSXSIGSignature(objRepr.get("sigma"), g1, g2);
        TCGAKOT15Commitment com = objRepr.get("comXSIG") != null ? new TCGAKOT15XSIGCommitment(g2, objRepr.get("comXSIG")) : new TCGAKOT15Commitment(g2, objRepr.get("com"));
        TCAKOT15OpenValue open = new TCAKOT15OpenValue(g1, g2, objRepr.get("open"));
        this.commitmentPairTC = new CommitmentPair(com, open);
    }

    public Representation getRepresentation() {
        ObjectRepresentation objRepr = new ObjectRepresentation();
        objRepr.put("sigma", this.sigmaXSIG.getRepresentation());
        if (this.commitmentPairTC.getCommitment() instanceof TCGAKOT15XSIGCommitment) {
            objRepr.put("comXSIG", this.commitmentPairTC.getCommitment().getRepresentation());
        } else {
            objRepr.put("com", this.commitmentPairTC.getCommitment().getRepresentation());
        }
        objRepr.put("open", this.commitmentPairTC.getOpenValue().getRepresentation());
        return objRepr;
    }

    public SPSXSIGSignature getSigmaXSIG() {
        return this.sigmaXSIG;
    }

    public CommitmentPair getCommitmentPairTC() {
        return this.commitmentPairTC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SPSFSP2Signature that = (SPSFSP2Signature)o;
        return Objects.equals(this.sigmaXSIG, that.sigmaXSIG) && Objects.equals(this.commitmentPairTC.getOpenValue(), that.commitmentPairTC.getOpenValue()) && Objects.equals(this.commitmentPairTC.getCommitment(), that.commitmentPairTC.getCommitment());
    }

    public int hashCode() {
        return Objects.hash(this.sigmaXSIG, this.commitmentPairTC.getOpenValue(), this.commitmentPairTC.getOpenValue());
    }
}

