/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.fsp2;

import java.util.Objects;
import org.cryptimeleon.craco.commitment.CommitmentPair;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.MultiMessageStructurePreservingSignatureScheme;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.fsp2.SPSFSP2Signature;
import org.cryptimeleon.craco.sig.sps.akot15.fsp2.SPSFSP2VerificationKey;
import org.cryptimeleon.craco.sig.sps.akot15.tc.TCAKOT15CommitmentScheme;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15CommitmentKey;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15XSIGCommitment;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15XSIGPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGSignature;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGSignatureScheme;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGSigningKey;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGVerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class SPSFSP2SignatureScheme
implements MultiMessageStructurePreservingSignatureScheme {
    @Represented
    AKOT15SharedPublicParameters pp;
    @Represented
    SPSXSIGSignatureScheme xsigInstance;
    @Represented
    TCAKOT15CommitmentScheme tcInstance;

    public SPSFSP2SignatureScheme(AKOT15SharedPublicParameters pp) {
        this.pp = pp;
        SPSXSIGPublicParameters ppXSIG = new SPSXSIGPublicParameters(pp, 1);
        TCGAKOT15XSIGPublicParameters ppTC = new TCGAKOT15XSIGPublicParameters(ppXSIG, pp.getMessageLength() + 2);
        this.xsigInstance = new SPSXSIGSignatureScheme(ppXSIG);
        this.tcInstance = new TCAKOT15CommitmentScheme(pp, ppTC);
    }

    public SPSFSP2SignatureScheme(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public SignatureKeyPair<SPSFSP2VerificationKey, SPSXSIGSigningKey> generateKeyPair(int numberOfMessages) {
        SignatureKeyPair<SPSXSIGVerificationKey, SPSXSIGSigningKey> key_xsig = this.xsigInstance.generateKeyPair(this.xsigInstance.getPublicParameters().getMessageLength());
        TCGAKOT15CommitmentKey key_tc = this.tcInstance.generateKey();
        return new SignatureKeyPair<SPSFSP2VerificationKey, SPSXSIGSigningKey>(new SPSFSP2VerificationKey(key_xsig.getVerificationKey(), key_tc), key_xsig.getSigningKey());
    }

    @Override
    public Signature sign(PlainText plainText, SigningKey secretKey) {
        if (!(secretKey instanceof SPSXSIGSigningKey)) {
            throw new IllegalArgumentException("this is not a valid signing key for this scheme");
        }
        if (plainText instanceof GroupElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("this is not a valid message for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        SPSXSIGSigningKey sk = (SPSXSIGSigningKey)secretKey;
        CommitmentPair tcCommitmentPair = this.tcInstance.commit(messageBlock);
        TCGAKOT15XSIGCommitment com = (TCGAKOT15XSIGCommitment)tcCommitmentPair.getCommitment();
        SPSXSIGSignature sigma = (SPSXSIGSignature)this.xsigInstance.sign(sk, com.toMessageBlock());
        return new SPSFSP2Signature(sigma, tcCommitmentPair);
    }

    @Override
    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey) {
        if (plainText instanceof GroupElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("this is not a valid message for this scheme");
        }
        if (!(publicKey instanceof SPSFSP2VerificationKey)) {
            throw new IllegalArgumentException("this is not a valid verification key for this scheme");
        }
        if (!(signature instanceof SPSFSP2Signature)) {
            throw new IllegalArgumentException("this is not a valid signature for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        SPSFSP2VerificationKey vk = (SPSFSP2VerificationKey)publicKey;
        SPSFSP2Signature sigma = (SPSFSP2Signature)signature;
        CommitmentPair commitmentPair = sigma.getCommitmentPairTC();
        return this.xsigInstance.verify(((TCGAKOT15XSIGCommitment)commitmentPair.getCommitment()).toMessageBlock(), (Signature)sigma.getSigmaXSIG(), vk.getVkXSIG()) != false && this.tcInstance.verify(sigma.getCommitmentPairTC().getCommitment(), sigma.getCommitmentPairTC().getOpenValue(), messageBlock);
    }

    @Override
    public PlainText restorePlainText(Representation repr) {
        return new MessageBlock(repr, r -> new GroupElementPlainText((Representation)r, this.pp.getG2GroupGenerator().getStructure()));
    }

    @Override
    public Signature restoreSignature(Representation repr) {
        return new SPSFSP2Signature(this.pp.getG1GroupGenerator().getStructure(), this.pp.getG2GroupGenerator().getStructure(), repr);
    }

    @Override
    public SigningKey restoreSigningKey(Representation repr) {
        return new SPSXSIGSigningKey(this.pp.getG1GroupGenerator().getStructure(), this.pp.getG2GroupGenerator().getStructure(), repr);
    }

    @Override
    public VerificationKey restoreVerificationKey(Representation repr) {
        return new SPSFSP2VerificationKey(this.pp.getG1GroupGenerator().getStructure(), this.pp.getG2GroupGenerator().getStructure(), repr);
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, VerificationKey pk) {
        if (this.pp == null) {
            throw new NullPointerException("Number of messages is stored in public parameters but they are not set");
        }
        return this.mapToPlaintext(bytes, this.pp.getMessageLength());
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, SigningKey sk) {
        if (this.pp == null) {
            throw new NullPointerException("Number of messages is stored in public parameters but they are not set");
        }
        return this.mapToPlaintext(bytes, this.pp.getMessageLength());
    }

    private MessageBlock mapToPlaintext(byte[] bytes, int messageBlockLength) {
        PlainText[] msgBlock = new GroupElementPlainText[messageBlockLength];
        msgBlock[0] = new GroupElementPlainText(this.pp.getG1GroupGenerator().pow((Zn.ZnElement)this.pp.getZp().injectiveValueOf(bytes)));
        for (int i = 1; i < msgBlock.length; ++i) {
            msgBlock[i] = new GroupElementPlainText(this.pp.getG1GroupGenerator());
        }
        return new MessageBlock(new MessageBlock(msgBlock), new MessageBlock(new PlainText[0]));
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return (this.pp.getG1GroupGenerator().getStructure().size().bitLength() - 1) / 8;
    }

    public Representation getRepresentation() {
        return new ReprUtil((Object)this).serialize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SPSFSP2SignatureScheme that = (SPSFSP2SignatureScheme)o;
        return Objects.equals(this.pp, that.pp) && Objects.equals(this.xsigInstance, that.xsigInstance) && Objects.equals(this.tcInstance, that.tcInstance);
    }

    public int hashCode() {
        return Objects.hash(this.pp, this.xsigInstance, this.tcInstance);
    }
}

