/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.pos;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.MultiMessageStructurePreservingSignatureScheme;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.SPSMessageSpaceVerifier;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSignature;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSigningKey;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSVerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class SPSPOSSignatureScheme
implements MultiMessageStructurePreservingSignatureScheme,
SPSMessageSpaceVerifier {
    @Represented
    private AKOT15SharedPublicParameters pp;

    public SPSPOSSignatureScheme(AKOT15SharedPublicParameters pp) {
        this.pp = pp;
    }

    public SPSPOSSignatureScheme(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public SignatureKeyPair<SPSPOSVerificationKey, SPSPOSSigningKey> generateKeyPair(int numberOfMessages) {
        if (numberOfMessages != this.pp.getMessageLength()) {
            throw new IllegalArgumentException(String.format("The expected the message length %d, but was %d", numberOfMessages, this.pp.getMessageLength()));
        }
        Zp.ZpElement exponentW = this.pp.getZp().getUniformlyRandomNonzeroElement();
        Zp.ZpElement[] exponentsChi = (Zp.ZpElement[])IntStream.range(0, numberOfMessages).mapToObj(x -> this.pp.getZp().getUniformlyRandomNonzeroElement()).toArray(Zp.ZpElement[]::new);
        GroupElement group1ElementW = this.pp.getG1GroupGenerator().pow((Zn.ZnElement)exponentW).compute();
        GroupElement[] group1ElementsChi = (GroupElement[])Arrays.stream(exponentsChi).map(x -> this.pp.getG1GroupGenerator().pow((Zn.ZnElement)x).compute()).toArray(GroupElement[]::new);
        SPSPOSSigningKey sk = new SPSPOSSigningKey(exponentsChi, exponentW);
        SPSPOSVerificationKey vk = new SPSPOSVerificationKey(group1ElementsChi, group1ElementW);
        SignatureKeyPair<SPSPOSVerificationKey, SPSPOSSigningKey> keyPair = new SignatureKeyPair<SPSPOSVerificationKey, SPSPOSSigningKey>(vk, sk);
        this.updateOneTimeKey(keyPair);
        return keyPair;
    }

    public void updateOneTimeKey(SignatureKeyPair<SPSPOSVerificationKey, SPSPOSSigningKey> keyPair) {
        Zp.ZpElement exponentA = this.pp.getZp().getUniformlyRandomElement();
        GroupElement group1ElementA = this.pp.getG1GroupGenerator().pow((Zn.ZnElement)exponentA).compute();
        keyPair.getSigningKey().setOneTimeKey(exponentA);
        keyPair.getVerificationKey().setOneTimeKey(group1ElementA);
    }

    @Override
    public SPSPOSSignature sign(PlainText plainText, SigningKey secretKey) {
        if (!(secretKey instanceof SPSPOSSigningKey)) {
            throw new IllegalArgumentException("Not a valid signing key for this scheme");
        }
        SPSPOSSigningKey sk = (SPSPOSSigningKey)secretKey;
        return this.sign(plainText, sk, sk.getOneTimeKey());
    }

    public SPSPOSSignature sign(PlainText plainText, SigningKey secretKey, Zp.ZpElement oneTimeKey) {
        if (plainText instanceof GroupElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        this.doMessageChecks(plainText, this.pp.getMessageLength(), this.pp.getG2GroupGenerator().getStructure());
        if (!(secretKey instanceof SPSPOSSigningKey)) {
            throw new IllegalArgumentException("Not a valid signing key for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        SPSPOSSigningKey sk = (SPSPOSSigningKey)secretKey;
        Zp.ZpElement exponentZeta = this.pp.getZp().getUniformlyRandomNonzeroElement();
        GroupElement group1ElementSigmaZ = this.pp.getG2GroupGenerator().pow((Zn.ZnElement)exponentZeta).compute();
        Zp.ZpElement lhsExponent = oneTimeKey;
        lhsExponent = lhsExponent.sub((Element)exponentZeta.mul((Element)sk.getExponentW()));
        GroupElement group1ElementSigmaR = this.pp.getG2GroupGenerator().pow((Zn.ZnElement)lhsExponent);
        for (int i = 0; i < messageBlock.length(); ++i) {
            GroupElement m_i = ((GroupElementPlainText)messageBlock.get(i)).get();
            group1ElementSigmaR = group1ElementSigmaR.op((Element)m_i.pow((Zn.ZnElement)sk.getExponentsChi()[i].neg()));
        }
        group1ElementSigmaR.compute();
        return new SPSPOSSignature(group1ElementSigmaZ, group1ElementSigmaR);
    }

    @Override
    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey) {
        if (!(publicKey instanceof SPSPOSVerificationKey)) {
            throw new IllegalArgumentException("Not a valid signing key for this scheme");
        }
        SPSPOSVerificationKey vk = (SPSPOSVerificationKey)publicKey;
        return this.verify(plainText, signature, publicKey, vk.getOneTimeKey());
    }

    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey, GroupElement oneTimeVerificationKey) {
        if (plainText instanceof GroupElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        this.doMessageChecks(plainText, this.pp.getMessageLength(), this.pp.getG2GroupGenerator().getStructure());
        if (!(publicKey instanceof SPSPOSVerificationKey)) {
            throw new IllegalArgumentException("Not a valid signing key for this scheme");
        }
        if (!(signature instanceof SPSPOSSignature)) {
            throw new IllegalArgumentException("Not a valid signing key for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        SPSPOSVerificationKey vk = (SPSPOSVerificationKey)publicKey;
        SPSPOSSignature sigma = (SPSPOSSignature)signature;
        BilinearMap bMap = this.pp.getBilinearMap();
        GroupElement ppelhs = bMap.apply(oneTimeVerificationKey, this.pp.getG2GroupGenerator()).compute();
        GroupElement pperhs = bMap.apply(vk.getGroup1ElementW(), sigma.getGroup2ElementZ());
        pperhs = pperhs.op((Element)bMap.apply(this.pp.getG1GroupGenerator(), sigma.getGroup2ElementR()));
        for (int i = 0; i < messageBlock.length(); ++i) {
            GroupElement m_i = ((GroupElementPlainText)messageBlock.get(i)).get();
            pperhs = pperhs.op((Element)bMap.apply(vk.getGroup1ElementsChi()[i], m_i));
        }
        pperhs.compute();
        return ppelhs.equals(pperhs);
    }

    @Override
    public PlainText restorePlainText(Representation repr) {
        return new MessageBlock(repr, r -> new GroupElementPlainText((Representation)r, this.pp.getG2GroupGenerator().getStructure()));
    }

    @Override
    public Signature restoreSignature(Representation repr) {
        return new SPSPOSSignature(repr, this.pp.getG2GroupGenerator().getStructure());
    }

    @Override
    public SigningKey restoreSigningKey(Representation repr) {
        return new SPSPOSSigningKey(repr, this.pp.getZp());
    }

    @Override
    public VerificationKey restoreVerificationKey(Representation repr) {
        return new SPSPOSVerificationKey(repr, this.pp.getG1GroupGenerator().getStructure());
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, VerificationKey pk) {
        if (this.pp == null) {
            throw new NullPointerException("Number of messages is stored in public parameters but they are not set");
        }
        return this.mapToPlainText(bytes, this.pp.getMessageLength());
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, SigningKey sk) {
        if (this.pp == null) {
            throw new NullPointerException("Number of messages is stored in public parameters but they are not set");
        }
        return this.mapToPlainText(bytes, this.pp.getMessageLength());
    }

    private MessageBlock mapToPlainText(byte[] bytes, int messageBlockLength) {
        PlainText[] msgBlock = new GroupElementPlainText[messageBlockLength];
        msgBlock[0] = new GroupElementPlainText(this.pp.getG2GroupGenerator().pow((Zn.ZnElement)this.pp.getZp().injectiveValueOf(bytes)));
        for (int i = 1; i < messageBlockLength; ++i) {
            msgBlock[i] = new GroupElementPlainText(this.pp.getG2GroupGenerator());
        }
        return new MessageBlock(msgBlock);
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return (this.pp.getG2GroupGenerator().getStructure().size().bitLength() - 1) / 8;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SPSPOSSignatureScheme that = (SPSPOSSignatureScheme)o;
        return Objects.equals(this.pp, that.pp);
    }

    public int hashCode() {
        return Objects.hash(this.pp);
    }
}

