/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.tc;

import java.util.Arrays;
import java.util.Objects;
import org.cryptimeleon.craco.commitment.Commitment;
import org.cryptimeleon.craco.commitment.CommitmentKey;
import org.cryptimeleon.craco.commitment.CommitmentPair;
import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.commitment.OpenValue;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.SPSMessageSpaceVerifier;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSignature;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSignatureScheme;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSigningKey;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSVerificationKey;
import org.cryptimeleon.craco.sig.sps.akot15.tc.TCAKOT15OpenValue;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15Commitment;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15CommitmentKey;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15CommitmentScheme;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15OpenValue;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15XSIGCommitmentKey;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15XSIGPublicParameters;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class TCAKOT15CommitmentScheme
implements CommitmentScheme,
SPSMessageSpaceVerifier {
    @Represented
    AKOT15SharedPublicParameters pp;
    @Represented
    SPSPOSSignatureScheme posInstance;
    @Represented
    TCGAKOT15CommitmentScheme gbcInstance;
    @Represented
    TCGAKOT15CommitmentKey commitmentKey;
    Zp.ZpElement[] oneTimeSecretKeys;
    GroupElement[] oneTimePublicKeys;

    public TCAKOT15CommitmentScheme(AKOT15SharedPublicParameters pp) {
        this.pp = pp;
        AKOT15SharedPublicParameters pp_pos = pp.clone();
        pp_pos.setMessageLength(1);
        this.posInstance = new SPSPOSSignatureScheme(pp_pos);
        AKOT15SharedPublicParameters pp_gbc = pp.clone();
        pp_gbc.setMessageLength(pp.getMessageLength() + 2);
        this.gbcInstance = new TCGAKOT15CommitmentScheme(pp_gbc);
        this.commitmentKey = this.generateKey();
    }

    public TCAKOT15CommitmentScheme(AKOT15SharedPublicParameters sharedPublicParametersParameters, TCGAKOT15XSIGPublicParameters tcGammaPublicParameters) {
        this.pp = new AKOT15SharedPublicParameters(sharedPublicParametersParameters.getBilinearGroup(), sharedPublicParametersParameters.getMessageLength(), tcGammaPublicParameters.getG1GroupGenerator(), tcGammaPublicParameters.getG2GroupGenerator());
        AKOT15SharedPublicParameters pp_pos = new AKOT15SharedPublicParameters(sharedPublicParametersParameters.getBilinearGroup(), 1, tcGammaPublicParameters.getG1GroupGenerator(), tcGammaPublicParameters.getG2GroupGenerator());
        this.posInstance = new SPSPOSSignatureScheme(pp_pos);
        this.gbcInstance = new TCGAKOT15CommitmentScheme(tcGammaPublicParameters);
        this.commitmentKey = this.generateKey();
    }

    public TCAKOT15CommitmentScheme(Representation repr) {
        ObjectRepresentation objRepr = (ObjectRepresentation)repr;
        this.pp = new AKOT15SharedPublicParameters(((RepresentableRepresentation)objRepr.get("pp")).getRepresentation());
        this.posInstance = new SPSPOSSignatureScheme(((RepresentableRepresentation)objRepr.get("posInstance")).getRepresentation());
        this.gbcInstance = new TCGAKOT15CommitmentScheme(((RepresentableRepresentation)objRepr.get("gbcInstance")).getRepresentation());
        this.commitmentKey = ((RepresentableRepresentation)objRepr.get("commitmentKey")).getRepresentedTypeName().equals(TCGAKOT15XSIGCommitmentKey.class.getName()) ? new TCGAKOT15XSIGCommitmentKey(this.pp.getG2GroupGenerator().getStructure(), ((RepresentableRepresentation)objRepr.get("commitmentKey")).getRepresentation()) : new TCGAKOT15CommitmentKey(this.pp.getG2GroupGenerator().getStructure(), ((RepresentableRepresentation)objRepr.get("commitmentKey")).getRepresentation());
    }

    public TCGAKOT15CommitmentKey generateKey() {
        return this.gbcInstance.getCommitmentKey();
    }

    @Override
    public CommitmentPair commit(PlainText plainText) {
        return this.commit(plainText, this.commitmentKey);
    }

    public CommitmentPair commit(PlainText plainText, CommitmentKey commitmentKey) {
        if (!(commitmentKey instanceof TCGAKOT15CommitmentKey)) {
            throw new IllegalArgumentException("This is not a valid commitment key for this scheme");
        }
        if (plainText instanceof GroupElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        this.doMessageChecks(plainText, this.pp.getMessageLength(), this.pp.getG2GroupGenerator().getStructure());
        MessageBlock messageBlock = (MessageBlock)plainText;
        TCGAKOT15CommitmentKey ck = (TCGAKOT15CommitmentKey)commitmentKey;
        SignatureKeyPair<? extends VerificationKey, ? extends SigningKey> posKeyPair = this.posInstance.generateKeyPair();
        this.generateOneTimeKeys();
        SPSPOSSignature[] sigmas = new SPSPOSSignature[this.pp.getMessageLength().intValue()];
        for (int i = 0; i < sigmas.length; ++i) {
            sigmas[i] = this.posInstance.sign(new MessageBlock((PlainText)messageBlock.get(i)), posKeyPair.getSigningKey(), this.oneTimeSecretKeys[i]);
        }
        PlainText[] msg_com = new RingElementPlainText[this.pp.getMessageLength() + 2];
        msg_com[0] = new RingElementPlainText((RingElement)((SPSPOSSigningKey)posKeyPair.getSigningKey()).getExponentW());
        msg_com[1] = new RingElementPlainText((RingElement)((SPSPOSSigningKey)posKeyPair.getSigningKey()).getExponentsChi()[0]);
        for (int i = 2; i < msg_com.length; ++i) {
            msg_com[i] = new RingElementPlainText((RingElement)this.oneTimeSecretKeys[i - 2]);
        }
        CommitmentPair gbcCommitmentPair = this.gbcInstance.commit(new MessageBlock(msg_com));
        TCAKOT15OpenValue open = new TCAKOT15OpenValue(((TCGAKOT15OpenValue)gbcCommitmentPair.getOpenValue()).getGroup1ElementR(), (SPSPOSVerificationKey)posKeyPair.getVerificationKey(), this.oneTimePublicKeys, sigmas);
        return new CommitmentPair(gbcCommitmentPair.getCommitment(), open);
    }

    private void generateOneTimeKeys() {
        this.oneTimeSecretKeys = new Zp.ZpElement[this.pp.getMessageLength().intValue()];
        this.oneTimePublicKeys = new GroupElement[this.pp.getMessageLength().intValue()];
        for (int i = 0; i < this.oneTimePublicKeys.length; ++i) {
            this.oneTimeSecretKeys[i] = this.pp.getZp().getUniformlyRandomNonzeroElement();
            this.oneTimePublicKeys[i] = this.pp.getG1GroupGenerator().pow((Zn.ZnElement)this.oneTimeSecretKeys[i]).compute();
        }
    }

    @Override
    public boolean verify(Commitment commitment, OpenValue openValue, PlainText plainText) {
        return this.verify(plainText, this.commitmentKey, commitment, openValue);
    }

    public boolean verify(PlainText plainText, CommitmentKey commitmentKey, Commitment commitment, OpenValue openValue) {
        if (!(commitmentKey instanceof TCGAKOT15CommitmentKey)) {
            throw new IllegalArgumentException("This is not a valid commitment key for this scheme");
        }
        if (!(commitment instanceof TCGAKOT15Commitment)) {
            throw new IllegalArgumentException("This is not a valid commitment for this scheme");
        }
        if (!(openValue instanceof TCAKOT15OpenValue)) {
            throw new IllegalArgumentException("This is not a valid commitment for this scheme");
        }
        if (plainText instanceof GroupElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        this.doMessageChecks(plainText, this.pp.getMessageLength(), this.pp.getG2GroupGenerator().getStructure());
        MessageBlock messageBlock = (MessageBlock)plainText;
        TCGAKOT15Commitment com = (TCGAKOT15Commitment)commitment;
        TCAKOT15OpenValue open = (TCAKOT15OpenValue)openValue;
        for (int i = 0; i < messageBlock.length(); ++i) {
            if (this.posInstance.verify(new MessageBlock((PlainText)messageBlock.get(i)), (Signature)open.getSpsPosSignatures()[i], open.spsPosVerificationKey, this.oneTimePublicKeys[i]).booleanValue()) continue;
            return false;
        }
        PlainText[] msg_com = new GroupElementPlainText[this.pp.getMessageLength() + 2];
        msg_com[0] = new GroupElementPlainText(open.getSpsPosVerificationKey().getGroup1ElementW());
        msg_com[1] = new GroupElementPlainText(open.getSpsPosVerificationKey().getGroup1ElementsChi()[0]);
        for (int i = 2; i < msg_com.length; ++i) {
            msg_com[i] = new GroupElementPlainText(this.oneTimePublicKeys[i - 2]);
        }
        return this.gbcInstance.verify(com, new TCGAKOT15OpenValue(open.getGroup1ElementGamma()), new MessageBlock(msg_com));
    }

    @Override
    public MessageBlock mapToPlaintext(byte[] bytes) {
        PlainText[] msgBlock = new GroupElementPlainText[this.pp.getMessageLength().intValue()];
        msgBlock[0] = new GroupElementPlainText(this.pp.getG2GroupGenerator().pow((Zn.ZnElement)this.pp.getZp().injectiveValueOf(bytes)));
        for (int i = 1; i < this.pp.getMessageLength(); ++i) {
            msgBlock[i] = new GroupElementPlainText(this.pp.getG2GroupGenerator());
        }
        return new MessageBlock(msgBlock);
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return (this.pp.getG1GroupGenerator().getStructure().size().bitLength() - 1) / 8;
    }

    @Override
    public Commitment restoreCommitment(Representation repr) {
        return new TCGAKOT15Commitment(this.pp.getG2GroupGenerator().getStructure(), repr);
    }

    @Override
    public OpenValue restoreOpenValue(Representation repr) {
        return new TCAKOT15OpenValue(this.pp.getG1GroupGenerator().getStructure(), this.pp.getG2GroupGenerator().getStructure(), repr);
    }

    public Representation getRepresentation() {
        ObjectRepresentation objRepr = (ObjectRepresentation)new ReprUtil((Object)this).serialize();
        objRepr.put("commitmentKey", (Representation)new RepresentableRepresentation((Representable)this.commitmentKey));
        return objRepr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TCAKOT15CommitmentScheme that = (TCAKOT15CommitmentScheme)o;
        return Objects.equals(this.pp, that.pp) && Objects.equals(this.posInstance, that.posInstance) && Objects.equals(this.gbcInstance, that.gbcInstance) && Objects.equals(this.commitmentKey, that.commitmentKey) && Arrays.equals(this.oneTimeSecretKeys, that.oneTimeSecretKeys) && Arrays.equals(this.oneTimePublicKeys, that.oneTimePublicKeys);
    }

    public int hashCode() {
        int result = Objects.hash(this.pp, this.posInstance, this.gbcInstance, this.commitmentKey);
        result = 31 * result + Arrays.hashCode(this.oneTimeSecretKeys);
        result = 31 * result + Arrays.hashCode(this.oneTimePublicKeys);
        return result;
    }
}

